/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering;

import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.ModEntities;
import com.ordana.immersive_weathering.common.ModParticles;
import com.ordana.immersive_weathering.common.blocks.LeafPilesRegistry;
import com.ordana.immersive_weathering.common.particles.EmberParticle;
import com.ordana.immersive_weathering.common.particles.LeafParticle;
import com.ordana.immersive_weathering.mixin.BlockColorAccessor;
import com.ordana.immersive_weathering.mixin.ItemColorAccessor;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.GlowParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IRegistryDelegate;

@Mod.EventBusSubscriber(modid="immersive_weathering", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ImmersiveWeatheringClient {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        LeafPilesRegistry.LEAF_PILES.get().values().forEach(l -> ItemBlockRenderTypes.setRenderLayer((Block)l, (RenderType)RenderType.m_110463_()));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.AZALEA_FLOWER_PILE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.VITRIFIED_SAND.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.ICICLE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WEEDS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SOOT.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.EXPOSED_IRON_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WEATHERED_IRON_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.RUSTED_IRON_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.EXPOSED_IRON_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WEATHERED_IRON_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.RUSTED_IRON_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.EXPOSED_IRON_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WEATHERED_IRON_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.RUSTED_IRON_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_IRON_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_EXPOSED_IRON_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_WEATHERED_IRON_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_RUSTED_IRON_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_IRON_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_EXPOSED_IRON_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_WEATHERED_IRON_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_RUSTED_IRON_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_IRON_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_EXPOSED_IRON_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_WEATHERED_IRON_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WAXED_RUSTED_IRON_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HANGING_ROOTS_WALL.get()), (RenderType)RenderType.m_110463_());
    }

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntities.FALLING_ICICLE.get(), FallingBlockRenderer::new);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerParticles(ParticleFactoryRegisterEvent event) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        particleEngine.m_107378_((ParticleType)ModParticles.EMBER.get(), EmberParticle.EmberFactory::new);
        particleEngine.m_107378_((ParticleType)ModParticles.SOOT.get(), LeafParticle.SimpleLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.OAK_LEAF.get(), LeafParticle.ColoredLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.SPRUCE_LEAF.get(), LeafParticle.ColoredLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.BIRCH_LEAF.get(), LeafParticle.ColoredLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.JUNGLE_LEAF.get(), LeafParticle.ColoredLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.ACACIA_LEAF.get(), LeafParticle.ColoredLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.DARK_OAK_LEAF.get(), LeafParticle.ColoredLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.AZALEA_LEAF.get(), LeafParticle.SimpleLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.AZALEA_FLOWER.get(), LeafParticle.SimpleLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.MULCH.get(), LeafParticle.SimpleLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.NULCH.get(), LeafParticle.SimpleLeafParticle::new);
        particleEngine.m_107378_((ParticleType)ModParticles.SCRAPE_RUST.get(), ScrapeRustFactory::new);
    }

    @Mod.EventBusSubscriber(modid="immersive_weathering", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientTicker {
        private static boolean clientTicked = false;

        @SubscribeEvent
        public static void firstClientTick(TickEvent.ClientTickEvent event) {
            if (!clientTicked && event.phase == TickEvent.Phase.END) {
                try {
                    BlockColors bc = Minecraft.m_91087_().m_91298_();
                    Map<IRegistryDelegate<Block>, BlockColor> blockColorMap = ((BlockColorAccessor)bc).getBlockColors();
                    LeafPilesRegistry.LEAF_PILES.get().forEach((key, value) -> {
                        BlockState leafState = key.m_49966_();
                        BlockColor color = (BlockColor)blockColorMap.get(key.delegate);
                        if (color != null) {
                            BlockColor newBc = (s, t, p, i) -> color.m_92566_(leafState, t, p, i);
                            bc.m_92589_(newBc, new Block[]{value});
                        }
                    });
                }
                catch (Exception bc) {
                    // empty catch block
                }
                try {
                    ItemColors ic = Minecraft.m_91087_().getItemColors();
                    Map<IRegistryDelegate<Item>, ItemColor> itemColorMap = ((ItemColorAccessor)ic).getItemColors();
                    LeafPilesRegistry.LEAF_PILES.get().forEach((key, value) -> {
                        ItemStack leafItem = new ItemStack((ItemLike)key);
                        ItemColor baseColor = (ItemColor)itemColorMap.get(leafItem.m_41720_().delegate);
                        if (baseColor != null) {
                            ItemColor newIc = (s, i) -> baseColor.m_92671_(leafItem, i);
                            ic.m_92689_(newIc, new ItemLike[]{value});
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                clientTicked = true;
            }
        }
    }

    public static class ScrapeRustFactory
    extends GlowParticle.ScrapeProvider {
        public ScrapeRustFactory(SpriteSet spriteSet) {
            super(spriteSet);
        }

        public Particle m_6966_(SimpleParticleType particleType, ClientLevel level, double p_172207_, double p_172208_, double p_172209_, double p_172210_, double p_172211_, double p_172212_) {
            Particle p = super.m_6966_(particleType, level, p_172207_, p_172208_, p_172209_, p_172210_, p_172211_, p_172212_);
            if (p != null) {
                if (level.f_46441_.nextBoolean()) {
                    p.m_107253_(0.76862746f, 0.4627451f, 0.28627452f);
                } else {
                    p.m_107253_(0.6901961f, 0.24705882f, 0.15686275f);
                }
            }
            return p;
        }
    }
}

