/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.block_growth;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.block_growth.BlockPair;
import com.ordana.immersive_weathering.block_growth.IBlockGrowth;
import com.ordana.immersive_weathering.block_growth.area_condition.AreaCondition;
import com.ordana.immersive_weathering.block_growth.position_test.PositionRuleTest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class BlockGrowthConfiguration
implements IBlockGrowth {
    public static final BlockGrowthConfiguration EMPTY = new BlockGrowthConfiguration(1.0f, (RuleTest)AlwaysTrueTest.f_73954_, Optional.empty(), List.of(), (HolderSet<Block>)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)Blocks.f_50016_)}), Optional.empty(), Optional.empty(), Optional.empty());
    public static final Codec<BlockGrowthConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("growth_chance").forGetter(BlockGrowthConfiguration::getGrowthChance), (App)RuleTest.f_74307_.fieldOf("replacing_target").forGetter(BlockGrowthConfiguration::getTargetPredicate), (App)AreaCondition.CODEC.optionalFieldOf("area_condition").forGetter(BlockGrowthConfiguration::getAreaCondition), (App)DirectionalList.CODEC.listOf().fieldOf("growth_for_face").forGetter(BlockGrowthConfiguration::encodeRandomLists), (App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122901_).fieldOf("owners").forGetter(b -> b.owners), (App)PositionRuleTest.CODEC.listOf().optionalFieldOf("position_predicates").forGetter(BlockGrowthConfiguration::getBiomePredicates), (App)Codec.BOOL.optionalFieldOf("target_self").forGetter(b -> b.targetSelf() ? Optional.of(Boolean.TRUE) : Optional.empty()), (App)Codec.BOOL.optionalFieldOf("destroy_target").forGetter(b -> b.destroyTarget() ? Optional.of(Boolean.TRUE) : Optional.empty())).apply((Applicative)instance, BlockGrowthConfiguration::new));
    private final float growthChance;
    private final HolderSet<Block> owners;
    private final RuleTest targetPredicate;
    private final SimpleWeightedRandomList<Direction> growthForDirection;
    private final Map<Direction, SimpleWeightedRandomList<BlockPair>> blockGrowths;
    private final Set<Block> possibleBlocks;
    private final List<PositionRuleTest> biomePredicates;
    private final boolean targetSelf;
    private final boolean destroyTarget;
    private final int maxRange;
    private final AreaCondition areaCondition;

    public BlockGrowthConfiguration(float growthChance, RuleTest targetPredicate, Optional<AreaCondition> areaCheck, List<DirectionalList> growthForDirection, HolderSet<Block> owners, Optional<List<PositionRuleTest>> biomePredicates, Optional<Boolean> targetSelf, Optional<Boolean> destroyTarget) {
        this.growthChance = growthChance;
        this.owners = owners;
        this.biomePredicates = biomePredicates.orElse(List.of());
        this.targetPredicate = targetPredicate;
        SimpleWeightedRandomList.Builder dirBuilder = SimpleWeightedRandomList.m_146263_();
        ImmutableMap.Builder growthBuilder = new ImmutableMap.Builder();
        ImmutableSet.Builder blockBuilder = new ImmutableSet.Builder();
        for (DirectionalList randomBlockList : growthForDirection) {
            if (randomBlockList.direction.isEmpty()) {
                dirBuilder = SimpleWeightedRandomList.m_146263_();
                growthBuilder = new ImmutableMap.Builder();
                blockBuilder = new ImmutableSet.Builder();
                this.decodeRandomList(Direction.UP, (SimpleWeightedRandomList.Builder<Direction>)dirBuilder, (ImmutableMap.Builder<Direction, SimpleWeightedRandomList<BlockPair>>)growthBuilder, (ImmutableSet.Builder<Block>)blockBuilder, randomBlockList);
                for (Direction d : Direction.values()) {
                    if (d == Direction.UP) continue;
                    growthBuilder.put((Object)d, randomBlockList.randomList);
                    dirBuilder.m_146271_((Object)d, 1);
                }
                break;
            }
            this.decodeRandomList(randomBlockList.direction.get(), (SimpleWeightedRandomList.Builder<Direction>)dirBuilder, (ImmutableMap.Builder<Direction, SimpleWeightedRandomList<BlockPair>>)growthBuilder, (ImmutableSet.Builder<Block>)blockBuilder, randomBlockList);
        }
        this.growthForDirection = dirBuilder.m_146270_();
        this.blockGrowths = growthBuilder.build();
        this.possibleBlocks = blockBuilder.build();
        this.areaCondition = areaCheck.orElse(AreaCondition.EMPTY);
        this.maxRange = this.areaCondition.getMaxRange();
        this.targetSelf = targetSelf.orElse(false);
        this.destroyTarget = destroyTarget.orElse(false);
    }

    private void decodeRandomList(Direction direction, SimpleWeightedRandomList.Builder<Direction> dirBuilder, ImmutableMap.Builder<Direction, SimpleWeightedRandomList<BlockPair>> growthBuilder, ImmutableSet.Builder<Block> blockBuilder, DirectionalList v) {
        int weight = v.weight.orElse(1);
        dirBuilder.m_146271_((Object)direction, weight);
        growthBuilder.put((Object)direction, v.randomList);
        v.randomList.m_146338_().stream().map(WeightedEntry.Wrapper::m_146310_).forEach(o -> {
            BlockState s;
            BlockState f = (BlockState)o.getFirst();
            if (f != null) {
                blockBuilder.add((Object)f.m_60734_());
            }
            if ((s = (BlockState)o.getFirst()) != null) {
                blockBuilder.add((Object)s.m_60734_());
            }
        });
    }

    public List<DirectionalList> encodeRandomLists() {
        ArrayList<DirectionalList> list = new ArrayList<DirectionalList>();
        for (WeightedEntry.Wrapper e : this.growthForDirection.m_146338_()) {
            Optional<Integer> weight;
            Optional<Direction> dir;
            if (this.growthForDirection.m_146338_().size() == 1) {
                dir = Optional.empty();
                weight = Optional.empty();
            } else {
                dir = Optional.of((Direction)e.m_146310_());
                weight = Optional.of(e.m_142631_().m_146281_());
            }
            list.add(new DirectionalList(dir, weight, this.blockGrowths.get(e.m_146310_())));
        }
        return list;
    }

    public RuleTest getTargetPredicate() {
        return this.targetPredicate;
    }

    public Optional<AreaCondition> getAreaCondition() {
        return this.areaCondition == AreaCondition.EMPTY ? Optional.empty() : Optional.of(this.areaCondition);
    }

    public Set<Block> getPossibleBlocks() {
        return this.possibleBlocks;
    }

    public boolean targetSelf() {
        return this.targetSelf;
    }

    public boolean destroyTarget() {
        return this.destroyTarget;
    }

    public Optional<List<PositionRuleTest>> getBiomePredicates() {
        return this.biomePredicates.isEmpty() ? Optional.empty() : Optional.of(this.biomePredicates);
    }

    public boolean isEmpty() {
        return this.possibleBlocks.isEmpty();
    }

    private boolean canGrow(BlockPos pos, Level level, Holder<Biome> biome) {
        if (this.growthChance == 0.0f) {
            return false;
        }
        if (level.f_46441_.nextFloat() < this.growthChance) {
            for (PositionRuleTest biomeTest : this.biomePredicates) {
                if (biomeTest.test(biome, pos, level)) continue;
                return false;
            }
            return level.isAreaLoaded(pos, this.maxRange);
        }
        return false;
    }

    public float getGrowthChance() {
        return this.growthChance;
    }

    @Override
    public Iterable<Block> getOwners() {
        return this.owners.m_203614_().map(Holder::m_203334_).collect(Collectors.toList());
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState self, ServerLevel level, Holder<Biome> biome) {
        if (this.canGrow(pos, (Level)level, biome)) {
            Direction dir = this.growthForDirection.m_146266_(level.f_46441_).orElse(Direction.UP);
            Random seed = new Random(Mth.m_14057_((Vec3i)pos));
            BlockPos targetPos = this.targetSelf ? pos : pos.m_142300_(dir);
            BlockState target = level.m_8055_(targetPos);
            if (this.targetSelf || this.targetPredicate.m_7715_(target, seed)) {
                BlockPair toPlace;
                SimpleWeightedRandomList<BlockPair> l;
                RuleTest ruleTest;
                if (this.targetSelf && (ruleTest = this.targetPredicate) instanceof RandomBlockMatchTest) {
                    RandomBlockMatchTest rbm = (RandomBlockMatchTest)ruleTest;
                    if (!(seed.nextFloat() < rbm.f_74260_)) {
                        return;
                    }
                }
                if ((l = this.blockGrowths.get(dir)) != null && (toPlace = (BlockPair)l.m_146266_(level.f_46441_).orElse(null)) != null && ((BlockState)toPlace.getFirst()).m_60710_((LevelReader)level, targetPos)) {
                    BlockPos targetPos2 = null;
                    BlockState target2 = null;
                    boolean db = toPlace.isDouble();
                    if (db && !this.targetPredicate.m_7715_(target2 = level.m_8055_(targetPos2 = targetPos.m_142300_(dir)), seed = new Random(Mth.m_14057_((Vec3i)pos)))) {
                        return;
                    }
                    if (this.areaCondition.test(pos, (Level)level, this)) {
                        if (this.destroyTarget) {
                            level.m_46961_(targetPos, true);
                        }
                        level.m_7731_(targetPos, this.setWaterIfNeeded((BlockState)toPlace.getFirst(), target), 2);
                        if (db) {
                            if (this.destroyTarget) {
                                level.m_46961_(targetPos2, true);
                            }
                            level.m_7731_(targetPos2, this.setWaterIfNeeded((BlockState)toPlace.getSecond(), target2), 2);
                        }
                        return;
                    }
                }
            }
        }
    }

    private BlockState setWaterIfNeeded(BlockState toPlace, BlockState target) {
        if (toPlace.m_61138_((Property)BlockStateProperties.f_61362_) && target.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return (BlockState)toPlace.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        return toPlace;
    }

    public record DirectionalList(Optional<Direction> direction, Optional<Integer> weight, SimpleWeightedRandomList<BlockPair> randomList) {
        public static final Codec<DirectionalList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Direction.f_175356_.optionalFieldOf("direction").forGetter(DirectionalList::direction), (App)Codec.INT.optionalFieldOf("weight").forGetter(DirectionalList::weight), (App)SimpleWeightedRandomList.m_146264_(BlockPair.CODEC).fieldOf("growth").forGetter(DirectionalList::randomList)).apply((Applicative)instance, DirectionalList::new));
    }
}

