/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.block_growth.area_condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.block_growth.BlockGrowthConfiguration;
import com.ordana.immersive_weathering.block_growth.area_condition.AreaCondition;
import com.ordana.immersive_weathering.common.WeatheringHelper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

record AreaCheck(int rX, int rY, int rZ, int requiredAmount, Optional<Integer> yOffset, Optional<RuleTest> mustHavePredicate, Optional<RuleTest> mustNotHavePredicate, Optional<HolderSet<Block>> extraIncluded) implements AreaCondition
{
    public static final String NAME = "generate_if_not_too_many";
    public static final Codec<AreaCheck> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("radiusX").forGetter(AreaCheck::rX), (App)Codec.INT.fieldOf("radiusY").forGetter(AreaCheck::rY), (App)Codec.INT.fieldOf("radiusZ").forGetter(AreaCheck::rZ), (App)Codec.INT.fieldOf("requiredAmount").forGetter(AreaCheck::requiredAmount), (App)Codec.INT.optionalFieldOf("yOffset").forGetter(AreaCheck::yOffset), (App)RuleTest.f_74307_.optionalFieldOf("must_have").forGetter(AreaCheck::mustHavePredicate), (App)RuleTest.f_74307_.optionalFieldOf("must_not_have").forGetter(AreaCheck::mustNotHavePredicate), (App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122901_).optionalFieldOf("includes").forGetter(AreaCheck::extraIncluded)).apply((Applicative)instance, AreaCheck::new));
    static final AreaCondition.AreaConditionType<AreaCheck> TYPE = new AreaCondition.AreaConditionType<AreaCheck>(CODEC, "generate_if_not_too_many");

    public AreaCondition.AreaConditionType<AreaCheck> getType() {
        return TYPE;
    }

    @Override
    public boolean test(BlockPos pos, Level level, BlockGrowthConfiguration config) {
        if (this.yOffset.isPresent()) {
            pos = pos.m_6630_(this.yOffset.get().intValue());
        }
        int count = 0;
        Random random = new Random(Mth.m_14057_((Vec3i)pos));
        boolean hasRequirement = this.mustHavePredicate.isEmpty();
        List<BlockPos> list = WeatheringHelper.grabBlocksAroundRandomly(pos, this.rX, this.rY, this.rZ);
        for (BlockPos p : list) {
            BlockState state = level.m_8055_(p);
            if (config.getPossibleBlocks().contains(state.m_60734_()) || this.extraIncluded.isPresent() && state.m_204341_(this.extraIncluded.get())) {
                ++count;
            }
            if (!hasRequirement && this.mustHavePredicate.get().m_7715_(state, random)) {
                hasRequirement = true;
                if (this.requiredAmount == -1) {
                    break;
                }
            } else if (this.mustNotHavePredicate.isPresent() && this.mustNotHavePredicate.get().m_7715_(state, random)) {
                return false;
            }
            if (count < this.requiredAmount) continue;
            return false;
        }
        return hasRequirement;
    }

    @Override
    public int getMaxRange() {
        return Math.max(this.rX, Math.max(this.rY, this.rZ));
    }
}

