/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.block_growth.area_condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.block_growth.BlockGrowthConfiguration;
import com.ordana.immersive_weathering.block_growth.area_condition.AreaCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

record NeighborCheck(RuleTest mustHavePredicate, Optional<RuleTest> mustNotHavePredicate, Optional<Integer> requiredAmount, Optional<List<Direction>> directions) implements AreaCondition
{
    public static final String NAME = "neighbor_based_generation";
    public static final Codec<NeighborCheck> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.f_74307_.fieldOf("must_have").forGetter(NeighborCheck::mustHavePredicate), (App)RuleTest.f_74307_.optionalFieldOf("must_not_have").forGetter(NeighborCheck::mustNotHavePredicate), (App)Codec.INT.optionalFieldOf("required_amount").forGetter(NeighborCheck::requiredAmount), (App)Direction.f_175356_.listOf().optionalFieldOf("directions").forGetter(NeighborCheck::directions)).apply((Applicative)instance, NeighborCheck::new));
    static final AreaCondition.AreaConditionType<NeighborCheck> TYPE = new AreaCondition.AreaConditionType<NeighborCheck>(CODEC, "neighbor_based_generation");

    public AreaCondition.AreaConditionType<NeighborCheck> getType() {
        return TYPE;
    }

    @Override
    public boolean test(BlockPos pos, Level level, BlockGrowthConfiguration config) {
        int count = 0;
        List list = this.directions.orElse(new ArrayList<Direction>(List.of(Direction.values())));
        Random random = new Random(Mth.m_14057_((Vec3i)pos));
        Collections.shuffle(list, random);
        int required = this.requiredAmount.orElse(1);
        for (Direction dir : list) {
            BlockPos p = pos.m_142300_(dir);
            BlockState state = level.m_8055_(p);
            if (this.mustHavePredicate.m_7715_(state, random)) {
                ++count;
            } else if (this.mustNotHavePredicate.isPresent() && this.mustNotHavePredicate.get().m_7715_(state, random)) {
                return false;
            }
            if (count < required) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxRange() {
        return 1;
    }
}

