/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.block_growth.hardcoded;

import com.ordana.immersive_weathering.block_growth.IBlockGrowth;
import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.WeatheringHelper;
import com.ordana.immersive_weathering.common.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.common.blocks.LeafPilesRegistry;
import com.ordana.immersive_weathering.configs.ServerConfigs;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;

public class LeavesGrowth
implements IBlockGrowth {
    @Override
    public Iterable<Block> getOwners() {
        return LeafPilesRegistry.LEAF_PILES.get().keySet();
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState state, ServerLevel level, Holder<Biome> biome) {
        Block leafPile;
        Random random = level.f_46441_;
        if ((!state.m_61138_((Property)LeavesBlock.f_54419_) || !((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue()) && (double)random.nextFloat() < (Double)ServerConfigs.FALLING_LEAVES.get() && (leafPile = (Block)LeafPilesRegistry.getFallenLeafPile(state).orElse(null)) != null && level.m_8055_(pos.m_7495_()).m_60795_()) {
            if (random.nextBoolean() && WeatheringHelper.isIciclePos(pos) && ((Biome)level.m_204166_(pos).m_203334_()).m_198904_(pos)) {
                level.m_7731_(pos.m_7495_(), (BlockState)((Block)ModBlocks.ICICLE.get()).m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)Direction.DOWN), 2);
            }
            if (!level.isAreaLoaded(pos, 2)) {
                return;
            }
            BlockPos targetPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
            int maxFallenLeavesReach = (Integer)ServerConfigs.LEAF_PILE_REACH.get();
            int maxPileHeight = (Integer)ServerConfigs.MAX_LEAF_PILE_HEIGHT.get();
            int dist = pos.m_123342_() - targetPos.m_123342_();
            if (dist < 0) {
                targetPos = pos;
                do {
                    targetPos = targetPos.m_7495_();
                    dist = pos.m_123342_() - targetPos.m_123342_();
                } while (level.m_8055_(targetPos).m_60767_().m_76336_() && dist < maxFallenLeavesReach);
                targetPos = targetPos.m_7494_();
            }
            if (dist < maxFallenLeavesReach) {
                BlockState replaceState = level.m_8055_(targetPos);
                boolean isOnLeaf = replaceState.m_60734_() instanceof LeafPileBlock;
                int pileHeight = 1;
                if (isOnLeaf && ((pileHeight = ((Integer)replaceState.m_61143_((Property)LeafPileBlock.LAYERS)).intValue()) == 0 || pileHeight >= maxPileHeight)) {
                    return;
                }
                BlockState baseLeaf = (BlockState)leafPile.m_49966_().m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(0));
                if (isOnLeaf || replaceState.m_60767_().m_76336_() && baseLeaf.m_60710_((LevelReader)level, targetPos) && !WeatheringHelper.hasEnoughBlocksAround(targetPos, 2, 2, 2, (Level)level, b -> b.m_60734_() instanceof LeafPileBlock, 6)) {
                    if (level.m_8055_(targetPos.m_7495_()).m_60713_(Blocks.f_49990_)) {
                        level.m_7731_(targetPos, (BlockState)baseLeaf.m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(0)), 2);
                    } else {
                        if (isOnLeaf) {
                            int original = pileHeight;
                            boolean hasLog = false;
                            BlockState[] neighbors = new BlockState[4];
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                neighbors[direction.m_122416_()] = level.m_8055_(targetPos.m_142300_(direction));
                            }
                            for (BlockState neighbor : neighbors) {
                                if (!WeatheringHelper.isLog(neighbor)) continue;
                                hasLog = true;
                                break;
                            }
                            for (BlockState neighbor : neighbors) {
                                int i;
                                if (!(neighbor.m_60734_() instanceof LeafPileBlock)) continue;
                                int n = i = hasLog ? maxPileHeight : Math.min((Integer)neighbor.m_61143_((Property)LeafPileBlock.LAYERS) - 1, maxPileHeight);
                                if (i <= pileHeight) continue;
                                pileHeight = Math.min(pileHeight + 1, i);
                                break;
                            }
                            if (pileHeight == original) {
                                return;
                            }
                        }
                        level.m_7731_(targetPos, (BlockState)baseLeaf.m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(pileHeight)), 2);
                    }
                }
            }
        }
    }
}

