/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common;

import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.block_growth.BlockGrowthHandler;
import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.ModParticles;
import com.ordana.immersive_weathering.common.WeatheringHelper;
import com.ordana.immersive_weathering.common.blocks.Waxables;
import com.ordana.immersive_weathering.common.blocks.Weatherable;
import com.ordana.immersive_weathering.common.blocks.crackable.Crackable;
import com.ordana.immersive_weathering.common.blocks.mossable.Mossable;
import com.ordana.immersive_weathering.common.blocks.rustable.Rustable;
import com.ordana.immersive_weathering.common.entity.FollowLeafCrownGoal;
import com.ordana.immersive_weathering.common.items.ModItems;
import com.ordana.immersive_weathering.configs.ServerConfigs;
import com.ordana.immersive_weathering.integration.IntegrationHandler;
import com.ordana.immersive_weathering.integration.QuarkPlugin;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagManager;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="immersive_weathering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    private static final BlockGrowthHandler GROWTH_MANAGER = new BlockGrowthHandler();
    private static final Map<String, ResourceLocation> fullReMap = new HashMap<String, ResourceLocation>(){
        {
            this.put("ash_block", ImmersiveWeathering.res("soot_block"));
            this.put("nulch", ImmersiveWeathering.res("nulch_block"));
            this.put("mulch", ImmersiveWeathering.res("mulch_block"));
        }
    };

    @SubscribeEvent
    public static void onTagUpdated(TagsUpdatedEvent event) {
        GROWTH_MANAGER.rebuild();
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        TagManager t = null;
        for (PreparableReloadListener l : event.getServerResources().m_206890_()) {
            TagManager tm;
            if (!(l instanceof TagManager)) continue;
            t = tm = (TagManager)l;
            ModEvents.GROWTH_MANAGER.registryAccess = t.f_144569_;
            event.addListener((PreparableReloadListener)GROWTH_MANAGER);
            break;
        }
        if (t == null) {
            throw new RuntimeException("Failed to register Growth Manager. This means many weathering features wont work:");
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            bee.f_21345_.m_25352_(3, (Goal)new FollowLeafCrownGoal((PathfinderMob)bee, 1.0, false));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Crackable crackable;
        ItemStack stack = event.getItemStack();
        Item i = stack.m_41720_();
        BlockPos pos = event.getPos();
        Level level = event.getWorld();
        BlockState state = level.m_8055_(pos);
        Block b = state.m_60734_();
        Player player = event.getPlayer();
        if (i instanceof ShearsItem) {
            BlockState newState = WeatheringHelper.getAzaleaSheared(state).orElse(null);
            if (newState != null) {
                if (level.f_46443_) {
                    ModParticles.spawnParticlesOnBlockFaces(level, pos, (ParticleOptions)ModParticles.AZALEA_FLOWER.get(), UniformInt.m_146622_((int)4, (int)6));
                } else {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)event.getFace(), (ItemStack)new ItemStack((ItemLike)ModItems.AZALEA_FLOWERS.get()));
                }
                level.m_5594_(player, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                BlockState s = Mossable.getUnaffectedMossBlock(state);
                if (s != state) {
                    newState = s;
                    if (IntegrationHandler.quark) {
                        newState = QuarkPlugin.fixVerticalSlab(newState, state);
                    }
                    if (!level.f_46443_) {
                        Block.m_152435_((Level)level, (BlockPos)pos, (Direction)event.getFace(), (ItemStack)new ItemStack((ItemLike)ModItems.MOSS_CLUMP.get()));
                    }
                    level.m_5594_(player, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (newState != null) {
                level.m_46597_(pos, newState);
                if (player != null) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(event.getHand()));
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        } else if (i instanceof FlintAndSteelItem) {
            BlockState s = Mossable.getUnaffectedMossBlock(state);
            if (s != state) {
                s = Weatherable.setStable(s);
                if (IntegrationHandler.quark) {
                    s = QuarkPlugin.fixVerticalSlab(s, state);
                }
                if (level.f_46443_) {
                    ModParticles.spawnParticlesOnBlockFaces(level, pos, (ParticleOptions)ParticleTypes.f_123744_, UniformInt.m_146622_((int)3, (int)5));
                }
                level.m_46597_(pos, s);
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player != null) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(event.getHand()));
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        } else if (i instanceof ShovelItem) {
            if (b instanceof CampfireBlock && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                Block.m_152435_((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)ModBlocks.SOOT.get()));
            }
            if (b instanceof FireBlock) {
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModBlocks.SOOT.get()));
                level.m_5594_(player, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                if (player != null) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(event.getHand()));
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        } else if (i instanceof PickaxeItem && (!((Boolean)ServerConfigs.CRACK_REQUIRES_SHIFTING.get()).booleanValue() || player.m_36341_())) {
            BlockState newBlock = Crackable.getCrackedBlock(state);
            if (newBlock != state) {
                if (IntegrationHandler.quark) {
                    newBlock = QuarkPlugin.fixVerticalSlab(newBlock, state);
                }
                if (!player.m_7500_() && newBlock instanceof Crackable) {
                    Crackable crackable2 = (Crackable)newBlock;
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)event.getFace(), (ItemStack)crackable2.getRepairItem(state).m_7968_());
                }
                level.m_5594_(player, pos, newBlock.m_60827_().m_56778_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, newBlock);
                if (player != null) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(event.getHand()));
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        } else if (i instanceof AxeItem) {
            BlockState unRusted;
            Rustable r;
            Block bark;
            BlockState stripped;
            if (((Boolean)ServerConfigs.BARK_ENABLED.get()).booleanValue() && (stripped = state.getToolModifiedState(level, pos, player, stack, ToolActions.AXE_STRIP)) != null && (bark = (Pair)WeatheringHelper.getBarkForStrippedLog(stripped).orElse(null)) != null) {
                Block.m_152435_((Level)level, (BlockPos)pos, (Direction)event.getFace(), (ItemStack)((Item)bark.getFirst()).m_7968_());
                level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player != null) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(event.getHand()));
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
                return;
            }
            bark = state.m_60734_();
            if (bark instanceof Rustable && (r = (Rustable)bark).m_142297_() != Rustable.RustLevel.RUSTED && (unRusted = (BlockState)r.getPrevious(state).orElse(null)) != null) {
                level.m_46597_(pos, unRusted);
                level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7696_(pos, unRusted.m_60734_(), 1, 0);
                if (player != null) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(event.getHand()));
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
                event.setCanceled(true);
                return;
            }
        } else if (i == Items.f_41903_ && b instanceof Rustable) {
            Rustable rustable = (Rustable)b;
            BlockState rusted = rustable.m_142123_(state).orElse(null);
            if (rusted != null) {
                level.m_5594_(player, pos, SoundEvents.f_12537_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, rusted);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        } else if (i == ModItems.MOSS_CLUMP.get()) {
            BlockState mossy = Mossable.getMossyBlock(state);
            if (mossy != state) {
                level.m_5594_(player, pos, SoundEvents.f_144190_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (IntegrationHandler.quark) {
                    mossy = QuarkPlugin.fixVerticalSlab(mossy, state);
                }
                level.m_46597_(pos, mossy);
                if (player != null && !player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        } else if (i instanceof HoneycombItem) {
            BlockState waxed = Waxables.getWaxedState(state).orElse(null);
            if (waxed != null) {
                level.m_5898_(player, 3003, pos, 0);
                level.m_46597_(pos, waxed);
                if (player != null && !player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        } else if (b instanceof Crackable && (crackable = (Crackable)b).getRepairItem(state) == i) {
            BlockState fixedBlock = crackable.getPreviousCracked(state).orElse(null);
            if (fixedBlock != null) {
                fixedBlock = Weatherable.setStable(fixedBlock);
                if (IntegrationHandler.quark) {
                    fixedBlock = QuarkPlugin.fixVerticalSlab(fixedBlock, state);
                }
                SoundEvent placeSound = fixedBlock.m_60827_().m_56777_();
                level.m_5594_(player, pos, placeSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, fixedBlock);
                if (player != null && !player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        } else {
            Pair fixedLog = WeatheringHelper.getBarkForStrippedLog(state).orElse(null);
            if (fixedLog != null && stack.m_41720_() == fixedLog.getFirst()) {
                BlockState fixedState = ((Block)fixedLog.getSecond()).m_152465_(state);
                level.m_5594_(player, pos, fixedState.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player != null && !player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_45482_(serverPlayer, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)i));
                }
                level.m_46597_(pos, fixedState);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        }
    }

    @SubscribeEvent
    public static void onRemapBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("immersive_weathering")) {
            String k = mapping.key.m_135815_();
            if (!fullReMap.containsKey(k)) continue;
            ResourceLocation i = fullReMap.get(k);
            try {
                ImmersiveWeathering.LOGGER.warn("Remapping block '{}' to '{}'", (Object)mapping.key, (Object)i);
                mapping.remap((IForgeRegistryEntry)((Block)ForgeRegistries.BLOCKS.getValue(i)));
            }
            catch (Throwable t) {
                ImmersiveWeathering.LOGGER.warn("Remapping block '{}' to '{}' failed: {}", (Object)mapping.key, (Object)i, (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void onRemapItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("immersive_weathering")) {
            String k = mapping.key.m_135815_();
            if (!fullReMap.containsKey(k)) continue;
            ResourceLocation i = fullReMap.get(k);
            try {
                ImmersiveWeathering.LOGGER.warn("Remapping item '{}' to '{}'", (Object)mapping.key, (Object)i);
                mapping.remap((IForgeRegistryEntry)((Item)ForgeRegistries.ITEMS.getValue(i)));
            }
            catch (Throwable t) {
                ImmersiveWeathering.LOGGER.warn("Remapping item '{}' to '{}' failed: {}", (Object)mapping.key, (Object)i, (Object)t);
            }
        }
    }
}

