/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common.blocks;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.common.items.ModItems;
import com.ordana.immersive_weathering.configs.ServerConfigs;
import com.ordana.immersive_weathering.integration.dynamic_stuff.ModDynamicRegistry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;

public class LeafPilesRegistry {
    public static boolean isDynamic = ModList.get().isLoaded("selene");
    public static final Supplier<Map<Block, LeafPileBlock>> LEAF_PILES = Suppliers.memoize(() -> {
        if (isDynamic) {
            return ModDynamicRegistry.getLeafToLeafPileMap();
        }
        return ImmutableMap.builder().put((Object)Blocks.f_50050_, (Object)((LeafPileBlock)((Object)((Object)ModBlocks.OAK_LEAF_PILE.get())))).put((Object)Blocks.f_50055_, (Object)((LeafPileBlock)((Object)((Object)ModBlocks.DARK_OAK_LEAF_PILE.get())))).put((Object)Blocks.f_50051_, (Object)((LeafPileBlock)((Object)((Object)ModBlocks.SPRUCE_LEAF_PILE.get())))).put((Object)Blocks.f_50052_, (Object)((LeafPileBlock)((Object)((Object)ModBlocks.BIRCH_LEAF_PILE.get())))).put((Object)Blocks.f_50053_, (Object)((LeafPileBlock)((Object)((Object)ModBlocks.JUNGLE_LEAF_PILE.get())))).put((Object)Blocks.f_50054_, (Object)((LeafPileBlock)((Object)((Object)ModBlocks.ACACIA_LEAF_PILE.get())))).put((Object)Blocks.f_152470_, (Object)((LeafPileBlock)((Object)((Object)ModBlocks.AZALEA_LEAF_PILE.get())))).put((Object)Blocks.f_152471_, (Object)((LeafPileBlock)((Object)((Object)ModBlocks.FLOWERING_AZALEA_LEAF_PILE.get())))).build();
    });
    public static final Supplier<Map<Block, Pair<Item, Block>>> STRIPPED_TO_BARK = Suppliers.memoize(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)Blocks.f_50010_, (Object)Pair.of((Object)((Item)ModItems.OAK_BARK.get()), (Object)Blocks.f_49999_)).put((Object)Blocks.f_50044_, (Object)Pair.of((Object)((Item)ModItems.OAK_BARK.get()), (Object)Blocks.f_50011_)).put((Object)Blocks.f_50006_, (Object)Pair.of((Object)((Item)ModItems.BIRCH_BARK.get()), (Object)Blocks.f_50001_)).put((Object)Blocks.f_50046_, (Object)Pair.of((Object)((Item)ModItems.BIRCH_BARK.get()), (Object)Blocks.f_50013_)).put((Object)Blocks.f_50005_, (Object)Pair.of((Object)((Item)ModItems.SPRUCE_BARK.get()), (Object)Blocks.f_50000_)).put((Object)Blocks.f_50045_, (Object)Pair.of((Object)((Item)ModItems.SPRUCE_BARK.get()), (Object)Blocks.f_50012_)).put((Object)Blocks.f_50007_, (Object)Pair.of((Object)((Item)ModItems.JUNGLE_BARK.get()), (Object)Blocks.f_50002_)).put((Object)Blocks.f_50047_, (Object)Pair.of((Object)((Item)ModItems.JUNGLE_BARK.get()), (Object)Blocks.f_50014_)).put((Object)Blocks.f_50009_, (Object)Pair.of((Object)((Item)ModItems.DARK_OAK_BARK.get()), (Object)Blocks.f_50004_)).put((Object)Blocks.f_50049_, (Object)Pair.of((Object)((Item)ModItems.DARK_OAK_BARK.get()), (Object)Blocks.f_50163_)).put((Object)Blocks.f_50008_, (Object)Pair.of((Object)((Item)ModItems.ACACIA_BARK.get()), (Object)Blocks.f_50003_)).put((Object)Blocks.f_50048_, (Object)Pair.of((Object)((Item)ModItems.ACACIA_BARK.get()), (Object)Blocks.f_50015_)).put((Object)Blocks.f_50696_, (Object)Pair.of((Object)((Item)ModItems.CRIMSON_SCALES.get()), (Object)Blocks.f_50695_)).put((Object)Blocks.f_50698_, (Object)Pair.of((Object)((Item)ModItems.CRIMSON_SCALES.get()), (Object)Blocks.f_50697_)).put((Object)Blocks.f_50687_, (Object)Pair.of((Object)((Item)ModItems.WARPED_SCALES.get()), (Object)Blocks.f_50686_)).put((Object)Blocks.f_50689_, (Object)Pair.of((Object)((Item)ModItems.WARPED_SCALES.get()), (Object)Blocks.f_50688_));
        if (isDynamic) {
            builder.putAll(ModDynamicRegistry.getBarkMap());
        }
        return builder.build();
    });

    public static void registerBus(IEventBus bus) {
        if (isDynamic) {
            ModDynamicRegistry.init(bus);
        }
    }

    public static Optional<Block> getFallenLeafPile(BlockState state) {
        Block b = state.m_60734_();
        if (((List)ServerConfigs.LEAF_PILES_BLACKLIST.get()).contains(b.getRegistryName().toString())) {
            return Optional.empty();
        }
        return Optional.ofNullable((Block)LEAF_PILES.get().get(b));
    }
}

