/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common.blocks.crackable;

import com.ordana.immersive_weathering.common.ModTags;
import com.ordana.immersive_weathering.common.blocks.PatchSpreader;
import com.ordana.immersive_weathering.common.blocks.crackable.Crackable;
import com.ordana.immersive_weathering.configs.ServerConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class CrackSpreader
implements PatchSpreader<Crackable.CrackLevel> {
    public static final CrackSpreader INSTANCE = new CrackSpreader();

    @Override
    public Class<Crackable.CrackLevel> getType() {
        return Crackable.CrackLevel.class;
    }

    @Override
    public double getInterestForDirection(Level level, BlockPos pos) {
        return (Double)ServerConfigs.CRACK_INTEREST_FOR_FACE.get();
    }

    @Override
    public double getDisjointGrowthChance(Level level, BlockPos pos) {
        return (Double)ServerConfigs.CRACK_DISJOINT_GROWTH.get();
    }

    @Override
    public double getUnWeatherableChance(Level level, BlockPos pos) {
        return (Double)ServerConfigs.CRACK_UN_WEATHERABLE_CHANCE.get();
    }

    @Override
    public boolean needsAirToSpread(Level level, BlockPos pos) {
        return (Boolean)ServerConfigs.CRACK_NEEDS_AIR.get();
    }

    @Override
    public PatchSpreader.WeatheringAgent getWeatheringEffect(BlockState state, Level level, BlockPos pos) {
        return state.m_204336_(ModTags.CRACKED) ? PatchSpreader.WeatheringAgent.WEATHER : PatchSpreader.WeatheringAgent.NONE;
    }

    @Override
    public PatchSpreader.WeatheringAgent getHighInfluenceWeatheringEffect(BlockState state, Level level, BlockPos pos) {
        FluidState fluid = state.m_60819_();
        if (fluid.m_205070_(FluidTags.f_13132_) || state.m_60734_() instanceof FireBlock) {
            return PatchSpreader.WeatheringAgent.WEATHER;
        }
        if (state.m_204336_(ModTags.CRACK_SOURCE)) {
            return PatchSpreader.WeatheringAgent.WEATHER;
        }
        return PatchSpreader.WeatheringAgent.NONE;
    }
}

