/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common.blocks.mossable;

import com.ordana.immersive_weathering.common.blocks.PatchSpreader;
import com.ordana.immersive_weathering.common.blocks.Weatherable;
import com.ordana.immersive_weathering.common.blocks.crackable.Crackable;
import com.ordana.immersive_weathering.common.blocks.mossable.Mossable;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface CrackableMossable
extends Mossable,
Crackable {
    @Override
    default public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> weatheringClass) {
        if (weatheringClass == Mossable.MossLevel.class) {
            return Optional.of(this.getMossSpreader());
        }
        if (weatheringClass == Crackable.CrackLevel.class) {
            return Optional.of(this.getCrackSpreader());
        }
        return Optional.empty();
    }

    @Override
    default public boolean shouldWeather(BlockState state, BlockPos pos, Level level) {
        return Mossable.super.shouldWeather(state, pos, level) || Crackable.super.shouldWeather(state, pos, level);
    }

    @Override
    default public void tryWeather(BlockState state, ServerLevel serverLevel, BlockPos pos, Random random) {
        if (random.nextFloat() < this.getWeatherChanceSpeed()) {
            boolean isMoss = this.getMossSpreader().getWantedWeatheringState(true, pos, (Level)serverLevel);
            Optional<Object> opt = Optional.empty();
            if (isMoss) {
                opt = this.getNextMossy(state);
            } else if (this.getCrackSpreader().getWantedWeatheringState(true, pos, (Level)serverLevel)) {
                opt = this.getNextCracked(state);
            }
            BlockState newState = opt.orElse((BlockState)state.m_61124_((Property)WEATHERABLE, (Comparable)((Object)Weatherable.WeatheringState.FALSE)));
            if (newState != state) {
                serverLevel.m_7731_(pos, newState, 2);
                if (!newState.m_61138_((Property)WEATHERABLE)) {
                    serverLevel.m_186460_(pos, state.m_60734_(), 1);
                }
            }
        }
    }
}

