/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.integration;

import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.common.blocks.VerticalSlabBlock;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.building.block.VerticalSlabBlock;
import vazkii.quark.content.client.module.GreenerGrassModule;

public class QuarkPlugin {
    public static final EnumProperty<VerticalSlabBlock.VerticalSlabType> QUARK_TYPE = VerticalSlabBlock.TYPE;

    public static void onFirstClientTick() {
        try {
            if (ModuleLoader.INSTANCE.isModuleEnabled(GreenerGrassModule.class)) {
                Method method = ObfuscationReflectionHelper.findMethod(GreenerGrassModule.class, (String)"registerGreenerColor", (Class[])new Class[]{Iterable.class, Boolean.TYPE});
                List<String> leaves = List.of("immersive_weathering:oak_leaf_pile", "immersive_weathering:dark_oak_leaf_pile", "immersive_weathering:acacia_leaf_pile", "immersive_weathering:jungle_leaf_pile", "immersive_weathering:spruce_leaf_pile", "immersive_weathering:birch_leaf_pile");
                method.setAccessible(true);
                method.invoke((Object)ModuleLoader.INSTANCE.getModuleInstance(GreenerGrassModule.class), leaves, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addVerticalSlabPair(ImmutableBiMap.Builder<Block, Block> builder, RegistryObject<Block> altered) {
        String name = ((Block)altered.get()).getRegistryName().m_135815_();
        name = name.replace("cracked_", "");
        ResourceLocation res = new ResourceLocation("quark", name = name.replace("mossy_", ""));
        if (ForgeRegistries.BLOCKS.containsKey(res)) {
            builder.put((Object)((Block)ForgeRegistries.BLOCKS.getValue(res)), (Object)((Block)altered.get()));
        } else {
            res = new ResourceLocation("minecraft", name);
            if (ForgeRegistries.BLOCKS.containsKey(res)) {
                builder.put((Object)((Block)ForgeRegistries.BLOCKS.getValue(res)), (Object)((Block)altered.get()));
            }
        }
    }

    public static void addAllVerticalSlabs(ImmutableBiMap.Builder<Block, Block> builder) {
        ImmutableBiMap map = builder.build();
        for (Map.Entry e : map.entrySet()) {
            if (!(e.getKey() instanceof SlabBlock)) continue;
            String vsName = ((Block)e.getKey()).getRegistryName().m_135815_().replace("slab", "vertical_slab");
            String vsAltName = ((Block)e.getValue()).getRegistryName().m_135815_().replace("slab", "vertical_slab");
            Block vs = null;
            Block vsAlt = null;
            ResourceLocation vsRes = new ResourceLocation("quark", vsName);
            if (ForgeRegistries.BLOCKS.containsKey(vsRes)) {
                vs = (Block)ForgeRegistries.BLOCKS.getValue(vsRes);
            } else {
                vsRes = ImmersiveWeathering.res(vsName);
                if (ForgeRegistries.BLOCKS.containsKey(vsRes)) {
                    vs = (Block)ForgeRegistries.BLOCKS.getValue(vsRes);
                }
            }
            ResourceLocation vsAltRes = new ResourceLocation("quark", vsAltName);
            if (ForgeRegistries.BLOCKS.containsKey(vsAltRes)) {
                vsAlt = (Block)ForgeRegistries.BLOCKS.getValue(vsAltRes);
            } else {
                vsAltRes = ImmersiveWeathering.res(vsAltName);
                if (ForgeRegistries.BLOCKS.containsKey(vsAltRes)) {
                    vsAlt = (Block)ForgeRegistries.BLOCKS.getValue(vsAltRes);
                }
            }
            if (vs == null || vsAlt == null) continue;
            builder.put((Object)vs, (Object)vsAlt);
        }
    }

    public static BlockState fixVerticalSlab(BlockState fixedBlock, BlockState original) {
        if (fixedBlock.m_61138_(QUARK_TYPE) && original.m_61138_(com.ordana.immersive_weathering.common.blocks.VerticalSlabBlock.TYPE)) {
            String name = ((VerticalSlabBlock.VerticalSlabType)((Object)original.m_61143_(com.ordana.immersive_weathering.common.blocks.VerticalSlabBlock.TYPE))).toString();
            return (BlockState)fixedBlock.m_61124_(QUARK_TYPE, (Comparable)((VerticalSlabBlock.VerticalSlabType)QUARK_TYPE.m_6215_(name).get()));
        }
        if (fixedBlock.m_61138_(com.ordana.immersive_weathering.common.blocks.VerticalSlabBlock.TYPE) && original.m_61138_(QUARK_TYPE)) {
            String name = ((VerticalSlabBlock.VerticalSlabType)original.m_61143_(QUARK_TYPE)).toString();
            return (BlockState)fixedBlock.m_61124_(com.ordana.immersive_weathering.common.blocks.VerticalSlabBlock.TYPE, (Comparable)((Object)((VerticalSlabBlock.VerticalSlabType)((Object)com.ordana.immersive_weathering.common.blocks.VerticalSlabBlock.TYPE.m_6215_(name).get()))));
        }
        return fixedBlock;
    }
}

