/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.mixin;

import com.google.common.collect.ImmutableList;
import com.ordana.immersive_weathering.common.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LiquidBlock.class})
public abstract class LiquidBlockMixin
extends Block
implements BucketPickup {
    @Shadow
    @Final
    public static ImmutableList<Direction> f_181233_;

    @Shadow
    protected abstract void m_54700_(LevelAccessor var1, BlockPos var2);

    @Shadow
    public abstract FlowingFluid getFluid();

    public LiquidBlockMixin(BlockBehaviour.Properties settings, FlowingFluid fluid) {
        super(settings);
    }

    @Inject(method={"shouldSpreadLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldSpreadLiquid(Level world, BlockPos pos, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        FlowingFluid fluid = this.getFluid();
        if (fluid != null && fluid.m_205067_(FluidTags.f_13132_)) {
            boolean hasWater = false;
            boolean blueIceDown = false;
            boolean blueIceUp = false;
            boolean hasBlueIce = false;
            boolean hasQuartz = false;
            boolean hasDiorite = false;
            boolean hasAsh = false;
            boolean hasMagma = false;
            boolean hasBubbles = false;
            boolean hasSoulfire = false;
            boolean hasClay = false;
            boolean hasSand = false;
            BlockState downState = world.m_8055_(pos.m_7495_());
            if (downState.m_60713_(Blocks.f_50568_)) {
                blueIceDown = true;
            } else if (downState.m_60713_(Blocks.f_50628_)) {
                hasBubbles = true;
            }
            if (world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50568_)) {
                blueIceUp = true;
            }
            for (Direction direction : f_181233_) {
                BlockPos blockPos = pos.m_142300_(direction.m_122424_());
                BlockState currentState = world.m_8055_(blockPos);
                if (currentState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                    hasWater = true;
                }
                if (currentState.m_60713_(Blocks.f_50472_)) {
                    hasQuartz = true;
                } else if (currentState.m_60713_(Blocks.f_50228_)) {
                    hasDiorite = true;
                } else if (currentState.m_60713_((Block)ModBlocks.ASH_BLOCK.get())) {
                    hasAsh = true;
                } else if (currentState.m_60713_(Blocks.f_50568_)) {
                    hasBlueIce = true;
                } else if (currentState.m_60713_(Blocks.f_50450_)) {
                    hasMagma = true;
                } else if (currentState.m_60713_(Blocks.f_50084_)) {
                    hasSoulfire = true;
                } else if (currentState.m_60713_(Blocks.f_50129_)) {
                    hasClay = true;
                } else if (currentState.m_204336_(BlockTags.f_13029_)) {
                    hasSand = true;
                }
                BlockState newState = null;
                if (hasWater && hasQuartz && hasDiorite) {
                    newState = Blocks.f_50122_.m_49966_();
                } else if (blueIceDown && blueIceUp) {
                    newState = Blocks.f_152550_.m_49966_();
                } else if (hasWater && hasQuartz) {
                    newState = Blocks.f_50228_.m_49966_();
                } else if (hasWater && hasDiorite) {
                    newState = Blocks.f_50334_.m_49966_();
                } else if (hasWater && hasAsh) {
                    newState = Blocks.f_152496_.m_49966_();
                } else if (hasMagma && hasBlueIce) {
                    newState = Blocks.f_50730_.m_49966_();
                } else if (hasBubbles) {
                    newState = Blocks.f_50450_.m_49966_();
                } else if (hasSoulfire) {
                    newState = Blocks.f_50723_.m_49966_();
                } else if (hasClay) {
                    pos = pos.m_142300_(direction.m_122424_());
                    newState = Blocks.f_50352_.m_49966_();
                } else if (hasSand) {
                    pos = pos.m_142300_(direction.m_122424_());
                    newState = ((Block)ModBlocks.VITRIFIED_SAND.get()).m_49966_();
                }
                if (newState == null) continue;
                world.m_46597_(pos, newState);
                this.m_54700_((LevelAccessor)world, pos);
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }
}

