/*
 * Decompiled with CFR 0.152.
 */
package vice.rubidium_extras.mixins.FrameCounter;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.gui.ForgeIngameGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vice.rubidium_extras.config.MagnesiumExtrasConfig;
import vice.rubidium_extras.features.FrameCounter.MinFrameProvider;
import vice.rubidium_extras.mixins.FrameCounter.FpsAccessorMixin;

@Mixin(value={ForgeIngameGui.class})
public class FrameCounterMixin {
    private int lastMeasuredFPS;
    private String runningAverageFPS;
    private final Queue<Integer> fpsRunningAverageQueue = new LinkedList<Integer>();

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void render(PoseStack matrixStack, float tickDelta, CallbackInfo info) {
        if (Objects.equals(MagnesiumExtrasConfig.fpsCounterMode.get(), "OFF")) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91066_.f_92063_ && !client.f_91066_.f_92065_) {
            return;
        }
        String displayString = null;
        int fps = FpsAccessorMixin.getFPS();
        displayString = Objects.equals(MagnesiumExtrasConfig.fpsCounterMode.get(), "ADVANCED") ? this.GetAdvancedFPSString(fps) : String.valueOf(fps);
        float textPos = ((Integer)MagnesiumExtrasConfig.fpsCounterPosition.get()).intValue();
        int textAlpha = 200;
        int textColor = 0xFFFFFF;
        float fontScale = 0.75f;
        double guiScale = client.m_91268_().m_85449_();
        if (guiScale > 0.0) {
            textPos = (float)((double)textPos / guiScale);
        }
        float maxTextPosX = client.m_91268_().m_85445_() - client.f_91062_.m_92895_(displayString);
        int n = client.m_91268_().m_85446_();
        Objects.requireNonNull(client.f_91062_);
        float maxTextPosY = n - 9;
        textPos = Math.min(textPos, maxTextPosX);
        int drawColor = (textAlpha & 0xFF) << 24 | textColor;
        client.f_91062_.m_92750_(matrixStack, displayString, textPos, textPos, drawColor);
    }

    private String GetAdvancedFPSString(int fps) {
        MinFrameProvider.recalculate();
        if (this.lastMeasuredFPS != fps) {
            this.lastMeasuredFPS = fps;
            if (this.fpsRunningAverageQueue.size() > 14) {
                this.fpsRunningAverageQueue.poll();
            }
            this.fpsRunningAverageQueue.offer(fps);
            int totalFps = 0;
            int frameCount = 0;
            for (Integer frameTime : this.fpsRunningAverageQueue) {
                totalFps += frameTime.intValue();
                ++frameCount;
            }
            int average = totalFps / frameCount;
            this.runningAverageFPS = String.valueOf(average);
        }
        return fps + " | MIN " + MinFrameProvider.getLastMinFrame() + " | AVG " + this.runningAverageFPS;
    }
}

