/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.sharing;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Either;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import mod.chiselsandbits.api.client.sharing.PatternIOException;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.utils.CompressionUtils;
import mod.chiselsandbits.utils.FileUtils;
import mod.chiselsandbits.utils.TextureUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class PatternSharingExecutor {
    private PatternSharingExecutor() {
        throw new IllegalStateException("Can not instantiate an instance of: PatternSharingExecutor. This is a utility class");
    }

    static void doSavePattern(IMultiStateItemStack multiStateItemStack, String patternName) {
        try {
            PatternSharingExecutor.savePattern(multiStateItemStack, patternName);
        }
        catch (PatternIOException e) {
            Minecraft.m_91087_().f_91074_.m_6352_(e.getErrorMessage(), Util.f_137441_);
        }
    }

    private static void savePattern(IMultiStateItemStack multiStateItemStack, String patternName) throws PatternIOException {
        byte[] textureAtlasData = PatternSharingExecutor.getBlockTextureAtlasData();
        ModelData modelData = PatternSharingExecutor.getModelQuadData(multiStateItemStack);
        byte[] chiselData = PatternSharingExecutor.getChiselData(multiStateItemStack);
        String dataString = PatternSharingExecutor.toDataString(textureAtlasData, modelData, chiselData);
        PatternSharingExecutor.writePatternDataToDisk(patternName, dataString);
    }

    private static void writePatternDataToDisk(String patternName, String dataString) throws PatternIOException {
        String encodedString = Base64.getEncoder().encodeToString(dataString.getBytes());
        Path targetPath = Paths.get(IClientConfiguration.getInstance().getPatternExportPath().get(), patternName + ".cbsbp");
        try {
            byte[] uncompressedData = encodedString.getBytes();
            byte[] compressedData = CompressionUtils.compress(uncompressedData);
            Files.write(FileUtils.ensureFileWritable(targetPath), compressedData, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new PatternIOException((Component)LocalStrings.PatternExportFailedCouldNotWriteFile.getText(), "Could not write pattern data file to disk", e);
        }
    }

    private static String toDataString(byte[] textureAtlasData, ModelData modelData, byte[] chiselData) {
        Gson gson = new GsonBuilder().create();
        JsonObject returnObject = new JsonObject();
        returnObject.addProperty("version", "1.0");
        returnObject.addProperty("textureAtlas", Base64.getEncoder().encodeToString(textureAtlasData));
        returnObject.add("modelData", gson.toJsonTree((Object)modelData));
        returnObject.addProperty("chiselData", Base64.getEncoder().encodeToString(chiselData));
        return gson.toJson((JsonElement)returnObject);
    }

    private static byte[] getChiselData(IMultiStateItemStack multiStateItemStack) throws PatternIOException {
        CompoundTag compoundTag = (CompoundTag)multiStateItemStack.serializeNBT();
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        try {
            NbtIo.m_128941_((CompoundTag)compoundTag, (DataOutput)dataOutput);
        }
        catch (IOException e) {
            throw new PatternIOException((Component)LocalStrings.PatternExportFailedCouldNotWriteChiselData.getText(), "Failed to write chisel data to memory.", e);
        }
        return dataOutput.toByteArray();
    }

    private static byte[] getBlockTextureAtlasData() throws PatternIOException {
        NativeImage currentAtlas = TextureUtils.getNativeImageFromTexture(InventoryMenu.f_39692_);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(byteArrayOutputStream);
        try {
            if (currentAtlas.m_85064_(channel)) {
                return byteArrayOutputStream.toByteArray();
            }
            throw new PatternIOException((Component)LocalStrings.PatternExportFailedGenericAtlasWriteFailure.getText(), "Failed to process the in-memory block atlas texture.");
        }
        catch (IOException e) {
            throw new PatternIOException((Component)LocalStrings.PatternExportFailedCouldNotWriteAtlas.getText(), "Failed to write the current block texture atlas to disk.", e);
        }
    }

    private static ModelData getModelQuadData(IMultiStateItemStack multiStateItemStack) {
        ItemStack blockStack = multiStateItemStack.toBlockStack();
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(blockStack, (Level)Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        Random random = new Random();
        ModelData modelData = new ModelData(Arrays.stream(Direction.values()).collect(Collectors.toMap(Function.identity(), direction -> bakedmodel.m_6840_(null, direction, random).stream().map(QuadData::new).collect(Collectors.toList()))), bakedmodel.m_6840_(null, null, random).stream().map(QuadData::new).collect(Collectors.toList()));
        return modelData;
    }

    static Either<IMultiStateItemStack, PatternIOException> doImportPattern(String patternName) {
        try {
            return Either.left((Object)PatternSharingExecutor.importPattern(patternName));
        }
        catch (PatternIOException e) {
            return Either.right((Object)e);
        }
    }

    private static IMultiStateItemStack importPattern(String patternName) throws PatternIOException {
        String patternData = PatternSharingExecutor.loadPatternDataFromDisk(patternName);
        return PatternSharingExecutor.getChiselData(patternData);
    }

    private static String loadPatternDataFromDisk(String patternName) throws PatternIOException {
        byte[] uncompressedData;
        byte[] compressedData;
        Path targetPath = Paths.get(IClientConfiguration.getInstance().getPatternExportPath().get(), patternName + ".cbsbp");
        if (!Files.exists(targetPath, new LinkOption[0])) {
            throw new PatternIOException((Component)LocalStrings.PatternImportFailedFileNotFound.getText(), "Failed to find the pattern file at the specified path.");
        }
        try {
            compressedData = Files.readAllBytes(targetPath);
        }
        catch (IOException e) {
            throw new PatternIOException((Component)LocalStrings.PatternImportFailedCouldNotReadFile.getText(), "Failed to read the pattern file from disk.", e);
        }
        try {
            uncompressedData = CompressionUtils.decompress(compressedData);
        }
        catch (IOException e) {
            throw new PatternIOException((Component)LocalStrings.PatternImportFailedCouldNotDecompressFile.getText(), "Could not decompress the pattern file from disk.", e);
        }
        catch (DataFormatException e) {
            throw new PatternIOException((Component)LocalStrings.PatternImportFailedCompressedDataInWrongFormat.getText(), "Could not decompress the pattern file from disk, the data is stored in an unknown format.", e);
        }
        byte[] decodedData = Base64.getDecoder().decode(uncompressedData);
        return new String(decodedData);
    }

    private static IMultiStateItemStack getChiselData(String dataString) throws PatternIOException {
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(dataString, JsonObject.class);
        String version = jsonObject.get("version").getAsString();
        if (version.equals("1.0")) {
            return PatternSharingExecutor.getVersion1ChiselData(jsonObject);
        }
        throw new PatternIOException((Component)LocalStrings.PatternImportFailedUnknownVersion.getText(), "The pattern file is stored in an unknown version.");
    }

    private static IMultiStateItemStack getVersion1ChiselData(JsonObject dataObject) throws PatternIOException {
        CompoundTag compoundTag;
        String encodedChiselString = dataObject.get("chiselData").getAsString();
        byte[] chiselData = Base64.getDecoder().decode(encodedChiselString);
        ByteArrayDataInput byteArrayDataInput = ByteStreams.newDataInput((byte[])chiselData);
        try {
            compoundTag = NbtIo.m_128928_((DataInput)byteArrayDataInput);
        }
        catch (IOException e) {
            throw new PatternIOException((Component)LocalStrings.PatternImportFailedInvalidChiselData.getText(), "The chisel data is stored in an invalid format.");
        }
        return new SingleBlockMultiStateItemStack((Item)ModItems.SINGLE_USE_PATTERN_ITEM.get(), compoundTag);
    }

    private static final class ModelData {
        final Map<Direction, List<QuadData>> directionalQuads;
        final List<QuadData> genericData;

        private ModelData(Map<Direction, List<QuadData>> directionalQuads, List<QuadData> genericData) {
            this.directionalQuads = directionalQuads;
            this.genericData = genericData;
        }
    }

    private static final class QuadData {
        private final int[] vertices;
        private final int tintIndex;
        private final Direction direction;
        private final boolean shade;

        private QuadData(BakedQuad source) {
            this.vertices = source.m_111303_();
            this.tintIndex = source.m_111305_();
            this.direction = source.m_111306_();
            this.shade = source.m_111307_();
        }

        public int[] getVertices() {
            return this.vertices;
        }

        public int getTintIndex() {
            return this.tintIndex;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public boolean isShade() {
            return this.shade;
        }
    }
}

