/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.chiselsandbits.platforms.core.network.INetworkChannel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeSimpleChannelPlatformDelegate
implements INetworkChannel {
    private final SimpleChannel simpleChannel;

    public ForgeSimpleChannelPlatformDelegate(SimpleChannel simpleChannel) {
        this.simpleChannel = simpleChannel;
    }

    @Override
    public <T> void register(int id, Class<T> msgClass, BiConsumer<T, FriendlyByteBuf> serializer, Function<FriendlyByteBuf, T> creator, INetworkChannel.MessageExecutionHandler<T> executionHandler) {
        this.simpleChannel.registerMessage(id, msgClass, serializer, creator, (message, contextSupplier) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)contextSupplier.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            executionHandler.execute(message, packetOrigin.isClient(), (Player)(packetOrigin.isClient() ? ctx.getSender() : null), arg_0 -> ((NetworkEvent.Context)ctx).enqueueWork(arg_0));
        });
    }

    @Override
    public void sendToServer(Object msg) {
        this.simpleChannel.sendToServer(msg);
    }

    @Override
    public void sendToPlayer(Object msg, ServerPlayer player) {
        this.simpleChannel.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }
}

