/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.config;

import dynamiclabs.immersivefx.environs.Environs;
import dynamiclabs.immersivefx.environs.effects.particles.RippleStyle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="environs", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Config {
    public static final Client CLIENT;
    private static final String CLIENT_CONFIG;
    public static final ForgeConfigSpec SPEC;

    private Config() {
    }

    private static void applyConfig() {
        Environs.LOGGER.setDebug((Boolean)Config.CLIENT.logging.enableLogging.get());
        Environs.LOGGER.setTraceMask((Integer)Config.CLIENT.logging.flagMask.get());
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Config.applyConfig();
        Environs.LOGGER.debug("Loaded config file %s", configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Environs.LOGGER.debug("Config file changed %s", configEvent.getConfig().getFileName());
        Config.applyConfig();
    }

    public static void setup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, CLIENT_CONFIG);
    }

    static {
        CLIENT_CONFIG = "dsurround" + File.separator + "environs-client.toml";
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final Logging logging;
        public final Biome biome;
        public final Effects effects;
        public final Aurora aurora;
        public final Fog fog;
        public final Sound sound;

        Client(@Nonnull ForgeConfigSpec.Builder builder) {
            this.logging = new Logging(builder);
            this.biome = new Biome(builder);
            this.effects = new Effects(builder);
            this.aurora = new Aurora(builder);
            this.fog = new Fog(builder);
            this.sound = new Sound(builder);
        }

        public static class Logging {
            public final ForgeConfigSpec.BooleanValue enableLogging;
            public final ForgeConfigSpec.IntValue flagMask;

            Logging(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Defines how logging will behave").push("Logging Options");
                this.enableLogging = builder.comment("Enables/disables debug logging of the mod").translation("environs.cfg.logging.EnableDebug").define("Debug Logging", false);
                this.flagMask = builder.comment("Bitmask for toggling various debug traces").translation("environs.cfg.logging.FlagMask").defineInRange("Debug Flag Mask", 0, 0, Integer.MAX_VALUE);
                builder.pop();
            }
        }

        public static class Biome {
            public final ForgeConfigSpec.IntValue worldSealevelOverride;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> biomeSoundBlacklist;

            Biome(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Options for controlling biome sound/effects").push("Biome Options");
                this.worldSealevelOverride = builder.comment("Sealevel to set for Overworld (0 use default for World)").translation("environs.cfg.biomes.Sealevel").defineInRange("Overworld Sealevel Override", 0, 0, 256);
                this.biomeSoundBlacklist = builder.comment("Dimension IDs where biome sounds will not be played").translation("environs.cfg.biomes.DimBlacklist").defineList("Dimension Blacklist", ArrayList::new, s -> true);
                builder.pop();
            }
        }

        public static class Effects {
            public final ForgeConfigSpec.BooleanValue enableFireFlies;
            public final ForgeConfigSpec.BooleanValue enableSteamJets;
            public final ForgeConfigSpec.BooleanValue enableFireJets;
            public final ForgeConfigSpec.BooleanValue enableBubbleJets;
            public final ForgeConfigSpec.BooleanValue enableDustJets;
            public final ForgeConfigSpec.BooleanValue enableFountainJets;
            public final ForgeConfigSpec.BooleanValue disableUnderwaterParticles;
            public final ForgeConfigSpec.BooleanValue enableWaterfalls;
            public final ForgeConfigSpec.IntValue waterfallCutoff;
            public final ForgeConfigSpec.BooleanValue enableWaterRipples;
            public final ForgeConfigSpec.EnumValue<RippleStyle> waterRippleStyle;

            Effects(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Options for controlling various effects").push("Effect Options");
                this.enableFireFlies = builder.worldRestart().comment("Enable/disable Firefly effect around plants").translation("environs.cfg.effects.Fireflies").define("Fireflies", true);
                this.enableSteamJets = builder.worldRestart().comment("Enable/disable Steam Jets where lava meets water").translation("environs.cfg.effects.Steam").define("Steam Jets", true);
                this.enableFireJets = builder.worldRestart().comment("Enable/disable Fire Jets in lava").translation("environs.cfg.effects.Fire").define("Fire Jets", true);
                this.enableBubbleJets = builder.worldRestart().comment("Enable/disable Bubble Jets under water").translation("environs.cfg.effects.Bubble").define("Bubble Jets", true);
                this.enableDustJets = builder.worldRestart().comment("Enable/disable Dust Motes dropping from under blocks").translation("environs.cfg.effects.Dust").define("Dust Jets", true);
                this.enableFountainJets = builder.worldRestart().comment("Enable/disable Fountain Jets spraying").translation("environs.cfg.effects.Fountain").define("Fountain Jets", true);
                this.enableWaterfalls = builder.worldRestart().comment("Enable/disable Water Splash effects when water spills down").translation("environs.cfg.effects.Splash").define("Waterfall Splash", true);
                this.waterfallCutoff = builder.comment("Limit sounds to waterfall strengths above this value").translation("environs.cfg.effects.WaterfallCutoff").defineInRange("Waterfall Strength Cutoff", 0, 0, 10);
                this.disableUnderwaterParticles = builder.worldRestart().comment("Enable/disable Minecraft's Underwater particle effect").translation("environs.cfg.effects.Underwater").define("Disable Underwater Particles", false);
                this.enableWaterRipples = builder.comment("Enable/disable Water Ripple effects for rain and water splash").translation("environs.cfg.effects.WaterRipple").define("Water Ripples", true);
                this.waterRippleStyle = builder.comment("The render style of water ripples").translation("environs.cfg.effects.WaterRippleStyle").defineEnum("Water Ripple Style", (Enum)RippleStyle.PIXELATED_CIRCLE, e -> true);
                builder.pop();
            }

            public int get_effectRange() {
                return (Integer)dynamiclabs.immersivefx.sndctrl.config.Config.CLIENT.effects.effectRange.get();
            }
        }

        public static class Aurora {
            public final ForgeConfigSpec.BooleanValue auroraEnabled;
            public final ForgeConfigSpec.IntValue maxBands;

            Aurora(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Options for controlling various effects").push("Effect Options");
                this.auroraEnabled = builder.comment("Enable/disable Aurora processing").translation("environs.cfg.aurora.Enable").define("Auroras", true);
                this.maxBands = builder.comment("Cap the maximum bands that will be rendered").translation("environs.cfg.aurora.MaxBands").defineInRange("Maximum Bands", 3, 0, 3);
                builder.pop();
            }
        }

        public static class Fog {
            public final ForgeConfigSpec.BooleanValue enableFog;
            public final ForgeConfigSpec.BooleanValue enableBiomeFog;
            public final ForgeConfigSpec.BooleanValue enableElevationHaze;
            public final ForgeConfigSpec.BooleanValue enableMorningFog;
            public final ForgeConfigSpec.BooleanValue enableBedrockFog;
            public final ForgeConfigSpec.BooleanValue enableWeatherFog;
            public final ForgeConfigSpec.IntValue morningFogChance;

            Fog(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Options that control the various fog effects in the client").push("Fog Options");
                this.enableFog = builder.comment("Enable/disable fog processing").translation("environs.cfg.fog.Enable").define("Enable Fog Processing", true);
                this.enableBiomeFog = builder.comment("Enable biome specific fog density and color").translation("environs.cfg.fog.Biome").define("Biome Fog", true);
                this.enableElevationHaze = builder.comment("Higher the player elevation the more haze that is experienced").translation("environs.cfg.fog.Haze").define("Elevation Haze", true);
                this.enableMorningFog = builder.comment("Show morning fog that eventually burns off").translation("environs.cfg.fog.Morning").define("Morning Fog", true);
                this.enableBedrockFog = builder.comment("Increase fog at bedrock layers").translation("environs.cfg.fog.Bedrock").define("Bedrock Fog", true);
                this.enableWeatherFog = builder.comment("Increase fog based on the strength of rain").translation("environs.cfg.fog.Weather").define("Weather Fog", true);
                this.morningFogChance = builder.comment("Percentage chance morning fog will occur").translation("environs.cfg.fog.MorningChance").defineInRange("Morning Fog Chance Percentage", 80, 1, 100);
                builder.pop();
            }
        }

        public static class Sound {
            public final ForgeConfigSpec.IntValue biomeSoundVolume;
            public final ForgeConfigSpec.IntValue spotSoundVolume;
            public final ForgeConfigSpec.IntValue waterfallSoundVolume;
            public final ForgeConfigSpec.BooleanValue occludeWaterfall;

            Sound(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Options for defining sound behavior").push("Sound Options");
                this.biomeSoundVolume = builder.comment("Scaling factor to apply to biome sounds").translation("environs.cfg.sound.BiomeVolume").defineInRange("Biome Sound Volume", 100, 0, 100);
                this.spotSoundVolume = builder.comment("Scaling factor to apply to spot sounds").translation("environs.cfg.sound.SpotVolume").defineInRange("Spot Sound Volume", 100, 0, 100);
                this.waterfallSoundVolume = builder.comment("Scaling factor to apply to waterfall sounds").translation("environs.cfg.sound.WaterfallVolume").defineInRange("Waterfall Volume", 100, 0, 100);
                this.occludeWaterfall = builder.comment("Occlude WATERFALL sounds").translation("environs.cfg.sound.OccludeWaterfall").define("Occlude WATERFALL sounds", false);
                builder.pop();
            }
        }
    }
}

