/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.effects;

import dynamiclabs.immersivefx.environs.effects.BlockEffectType;
import dynamiclabs.immersivefx.environs.effects.JetEffect;
import dynamiclabs.immersivefx.environs.effects.emitters.BubbleJet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BubbleJetEffect
extends JetEffect {
    public BubbleJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.BUBBLE;
    }

    @Override
    public boolean canTrigger(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        if (WATER_PREDICATE.test(state)) {
            BlockState belowBlock = provider.m_8055_(pos.m_7495_());
            Material material = belowBlock.m_60767_();
            boolean isSolidBlock = material.m_76333_();
            if (isSolidBlock) {
                boolean bl = false;
            }
            return isSolidBlock && super.canTrigger(provider, state, pos, random);
        }
        return false;
    }

    @Override
    public void doEffect(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int liquidBlocks = BubbleJetEffect.countVerticalBlocks(provider, pos, WATER_PREDICATE, 1);
        if (liquidBlocks > 0) {
            BubbleJet effect = new BubbleJet(liquidBlocks, provider, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
            this.addEffect(effect);
        }
    }
}

