/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.effects;

import dynamiclabs.immersivefx.environs.effects.BlockEffect;
import dynamiclabs.immersivefx.environs.effects.emitters.Jet;
import dynamiclabs.immersivefx.environs.handlers.ParticleSystems;
import dynamiclabs.immersivefx.environs.handlers.scripts.ConditionEvaluator;
import dynamiclabs.immersivefx.lib.math.MathStuff;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class JetEffect
extends BlockEffect {
    public static final int MAX_STRENGTH = 10;
    public static final Predicate<BlockState> FLUID_PREDICATE = state -> !state.m_60819_().m_76178_();
    public static final Predicate<BlockState> LAVA_PREDICATE = state -> state.m_60819_().m_205070_(FluidTags.f_13132_);
    public static final Predicate<BlockState> WATER_PREDICATE = state -> state.m_60819_().m_205070_(FluidTags.f_13131_);
    public static final Predicate<BlockState> SOLID_PREDICATE = state -> state.m_60767_().m_76333_();
    public static final Predicate<BlockState> LIT_FURNACE = state -> state.m_60734_() instanceof AbstractFurnaceBlock && (Boolean)state.m_61143_((Property)AbstractFurnaceBlock.f_48684_) != false;
    public static final Predicate<BlockState> HOTBLOCK_PREDICATE = state -> LAVA_PREDICATE.test((BlockState)state) || state.m_60734_() == Blocks.f_50450_ || LIT_FURNACE.test((BlockState)state);

    public JetEffect(int chance) {
        super(chance);
    }

    public static int countVerticalBlocks(@Nonnull BlockGetter provider, @Nonnull BlockPos pos, @Nonnull Predicate<BlockState> predicate, int step) {
        int count;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (count = 0; count < 10 && predicate.test(provider.m_8055_((BlockPos)mutable)); ++count) {
            mutable.m_142448_(mutable.m_123342_() + step);
        }
        return MathStuff.clamp(count, 0, 10);
    }

    public static int countCubeBlocks(@Nonnull BlockGetter provider, @Nonnull BlockPos pos, @Nonnull Predicate<BlockState> predicate, boolean fastFirst) {
        int blockCount = 0;
        for (int k = -1; k <= 1; ++k) {
            for (int j = -1; j <= 1; ++j) {
                for (int i = -1; i <= 1; ++i) {
                    BlockState state = provider.m_8055_(pos.m_142082_(i, j, k));
                    if (!predicate.test(state)) continue;
                    if (fastFirst) {
                        return 1;
                    }
                    ++blockCount;
                }
            }
        }
        return blockCount;
    }

    @Override
    public boolean canTrigger(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        if (this.alwaysExecute() || random.nextInt(this.getChance()) == 0) {
            return ParticleSystems.okToSpawn(pos) && ConditionEvaluator.INSTANCE.check(this.getConditions());
        }
        return false;
    }

    protected void addEffect(@Nonnull Jet fx) {
        ParticleSystems.add(fx);
    }
}

