/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.effects.particles;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.effects.particles.MoteFireFly;
import dynamiclabs.immersivefx.environs.effects.particles.MoteRainSplash;
import dynamiclabs.immersivefx.environs.effects.particles.MoteWaterRipple;
import dynamiclabs.immersivefx.environs.effects.particles.MoteWaterSpray;
import dynamiclabs.immersivefx.environs.effects.particles.RippleStyle;
import dynamiclabs.immersivefx.lib.particles.CollectionManager;
import dynamiclabs.immersivefx.lib.particles.DSParticleRenderType;
import dynamiclabs.immersivefx.lib.particles.IParticleCollection;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environs", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class Collections {
    private static final DSParticleRenderType RIPPLE_RENDER = new DSParticleRenderType(new ResourceLocation("environs", "textures/particles/ripple.png")){

        @Override
        protected ResourceLocation getTexture() {
            return ((RippleStyle)((Object)Config.CLIENT.effects.waterRippleStyle.get())).getTexture();
        }

        @Override
        public void m_6505_(@Nonnull BufferBuilder buffer, @Nonnull TextureManager textureManager) {
            super.m_6505_(buffer, textureManager);
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    };
    private static final DSParticleRenderType SPRAY_RENDER = new DSParticleRenderType(new ResourceLocation("environs", "textures/particles/rainsplash.png"));
    private static final ParticleRenderType FIREFLY_RENDER = ParticleRenderType.f_107431_;
    private static final IParticleCollection theRipples = CollectionManager.create("Rain Ripples", RIPPLE_RENDER);
    private static final IParticleCollection theSprays = CollectionManager.create("Water Spray", SPRAY_RENDER);
    private static final IParticleCollection theFireFlies = CollectionManager.create("Fireflies", FIREFLY_RENDER);

    private Collections() {
    }

    public static void addWaterRipple(@Nonnull BlockGetter world, double x, double y, double z) {
        if (theRipples.canFit()) {
            MoteWaterRipple mote = new MoteWaterRipple(world, x, y, z);
            theRipples.add(mote);
        }
    }

    public static boolean addWaterSpray(@Nonnull BlockGetter world, double x, double y, double z, double dX, double dY, double dZ) {
        if (theSprays.canFit()) {
            MoteWaterSpray mote = new MoteWaterSpray(world, x, y, z, dX, dY, dZ);
            theSprays.add(mote);
            return true;
        }
        return false;
    }

    public static boolean canFitWaterSpray() {
        return theSprays.canFit();
    }

    public static void addRainSplash(@Nonnull BlockGetter world, double x, double y, double z) {
        if (theSprays.canFit()) {
            MoteRainSplash mote = new MoteRainSplash(world, x, y, z);
            theSprays.add(mote);
        }
    }

    public static void addFireFly(@Nonnull BlockGetter world, double x, double y, double z) {
        if (theFireFlies.canFit()) {
            MoteFireFly mote = new MoteFireFly(world, x, y, z);
            theFireFlies.add(mote);
        }
    }
}

