/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import dynamiclabs.immersivefx.environs.Environs;
import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.handlers.CommonState;
import dynamiclabs.immersivefx.environs.handlers.HandlerBase;
import dynamiclabs.immersivefx.environs.shaders.ShaderPrograms;
import dynamiclabs.immersivefx.environs.shaders.aurora.AuroraFactory;
import dynamiclabs.immersivefx.environs.shaders.aurora.AuroraUtils;
import dynamiclabs.immersivefx.environs.shaders.aurora.IAurora;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.events.DiagnosticEvent;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import dynamiclabs.immersivefx.lib.math.LoggingTimerEMA;
import javax.annotation.Nonnull;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public final class AuroraHandler
extends HandlerBase {
    private static final IModLog LOGGER = Environs.LOGGER.createChild(AuroraHandler.class);
    private static AuroraHandler handler;
    private final LoggingTimerEMA render = new LoggingTimerEMA("Render Aurora");
    private IAurora current;
    private int dimensionId;

    public AuroraHandler() {
        super("Aurora");
    }

    @Override
    public void onConnect() {
        handler = this;
        this.current = null;
    }

    @Override
    public void onDisconnect() {
        this.current = null;
        handler = null;
    }

    private boolean isAuroraTimeOfDay() {
        return CommonState.getDayCycle().isAuroraVisible();
    }

    private boolean canSpawnAurora() {
        return this.current == null && this.canAuroraStay();
    }

    private boolean canAuroraStay() {
        if (!((Boolean)Config.CLIENT.aurora.auroraEnabled.get()).booleanValue()) {
            return false;
        }
        return this.isAuroraTimeOfDay() && AuroraUtils.getChunkRenderDistance() >= 6 && AuroraUtils.dimensionHasAuroras() && CommonState.getTruePlayerBiome().getHasAurora();
    }

    @Override
    public void process(@Nonnull Player player) {
        if (this.current != null) {
            if (this.current.isComplete() || this.dimensionId != CommonState.getDimensionId() || !((Boolean)Config.CLIENT.aurora.auroraEnabled.get()).booleanValue()) {
                this.current = null;
            } else {
                this.current.update();
                boolean isDying = this.current.isDying();
                boolean canStay = this.canAuroraStay();
                if (isDying && canStay) {
                    LOGGER.debug("Unfading aurora...", new Object[0]);
                    this.current.setFading(false);
                } else if (!isDying && !canStay) {
                    LOGGER.debug("Aurora fade...", new Object[0]);
                    this.current.setFading(true);
                }
            }
        }
        if (this.canSpawnAurora()) {
            this.current = AuroraFactory.produce(AuroraUtils.getSeed());
            LOGGER.debug("New aurora [%s]", this.current.toString());
        }
        this.dimensionId = CommonState.getDimensionId();
    }

    private void doRender(@Nonnull PoseStack matrixStack, float partialTick) {
        this.render.begin();
        if (this.current != null) {
            this.current.render(matrixStack, partialTick);
        }
        this.render.end();
    }

    public static void renderHook(@Nonnull PoseStack matrixStack, float partialTick) {
        if (handler != null) {
            ProfilerFiller profiler = GameUtils.getMC().m_91307_();
            profiler.m_6180_("Aurora Render");
            handler.doRender(matrixStack, partialTick);
            profiler.m_7238_();
        }
    }

    @SubscribeEvent
    public void diagnostic(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            if (ShaderPrograms.MANAGER.supported()) {
                event.getLeft().add("Aurora: " + (this.current == null ? "NONE" : this.current.toString()));
                event.getRenderTimers().add(this.render);
            } else {
                event.getLeft().add("Aurora: Disabled");
            }
        }
    }
}

