/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.handlers;

import dynamiclabs.immersivefx.environs.library.BiomeInfo;
import dynamiclabs.immersivefx.environs.library.BiomeLibrary;
import dynamiclabs.immersivefx.environs.library.DimensionInfo;
import dynamiclabs.immersivefx.lib.DayCycle;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.MinecraftClock;
import dynamiclabs.immersivefx.lib.TickCounter;
import dynamiclabs.immersivefx.lib.seasons.Season;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class CommonState {
    private static CommonState instance = new CommonState();
    Season season = Season.NONE;
    BiomeInfo playerBiome = BiomeLibrary.WTF_INFO;
    BiomeInfo truePlayerBiome = BiomeLibrary.WTF_INFO;
    int dimensionId;
    String dimensionName = "";
    DimensionInfo dimInfo = DimensionInfo.NONE;
    BlockPos playerPosition = BlockPos.f_121853_;
    Vec3 playerEyePosition = Vec3.f_82478_;
    float biomeTemperature = 0.0f;
    boolean inside;
    boolean isUnderground;
    boolean isInSpace;
    boolean isInClouds;
    boolean isInVillage;
    int lightLevel;
    DayCycle dayCycle = DayCycle.NO_SKY;
    MinecraftClock clock = new MinecraftClock();

    static CommonState getData() {
        return instance;
    }

    static void reset() {
        instance = new CommonState();
    }

    CommonState() {
    }

    public static Season getSeason() {
        return CommonState.instance.season;
    }

    public static BiomeInfo getPlayerBiome() {
        return CommonState.instance.playerBiome;
    }

    public static BiomeInfo getTruePlayerBiome() {
        return CommonState.instance.truePlayerBiome;
    }

    public static int getDimensionId() {
        return CommonState.instance.dimensionId;
    }

    public static String getDimensioName() {
        return CommonState.instance.dimensionName;
    }

    public static DimensionInfo getDimensionInfo() {
        return CommonState.instance.dimInfo;
    }

    public static BlockPos getPlayerPosition() {
        return CommonState.instance.playerPosition;
    }

    public static Vec3 getPlayerEyePosition() {
        return CommonState.instance.playerEyePosition;
    }

    public static float getCurrentTemperature() {
        return CommonState.instance.biomeTemperature;
    }

    public static boolean isInside() {
        return CommonState.instance.inside;
    }

    public static boolean isUnderground() {
        return CommonState.instance.isUnderground;
    }

    public static boolean isInClouds() {
        return CommonState.instance.isInClouds;
    }

    public static boolean isInSpace() {
        return CommonState.instance.isInSpace;
    }

    public static boolean isInVillage() {
        return CommonState.instance.isInVillage;
    }

    public static int getLightLevel() {
        return CommonState.instance.lightLevel;
    }

    public static long getTick() {
        return TickCounter.getTickCount();
    }

    public static DayCycle getDayCycle() {
        return CommonState.instance.dayCycle;
    }

    public static MinecraftClock getClock() {
        return CommonState.instance.clock;
    }

    public static LevelReader getBlockReader() {
        return GameUtils.getWorld();
    }
}

