/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.handlers.scripts;

import dynamiclabs.immersivefx.environs.handlers.scripts.StateVariables;
import dynamiclabs.immersivefx.lib.scripting.ExecutionContext;
import dynamiclabs.immersivefx.lib.scripting.sets.BiomeVariables;
import dynamiclabs.immersivefx.lib.scripting.sets.DimensionVariables;
import dynamiclabs.immersivefx.lib.scripting.sets.DiurnalCycleVariables;
import dynamiclabs.immersivefx.lib.scripting.sets.PlayerVariables;
import dynamiclabs.immersivefx.lib.scripting.sets.SeasonVariables;
import dynamiclabs.immersivefx.lib.scripting.sets.WeatherVariables;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ConditionEvaluator {
    public static final ConditionEvaluator INSTANCE = new ConditionEvaluator();
    private final ExecutionContext context = new ExecutionContext("Conditions");

    private ConditionEvaluator() {
        this.context.add(new BiomeVariables());
        this.context.add(new DimensionVariables());
        this.context.add(new DiurnalCycleVariables());
        this.context.add(new PlayerVariables());
        this.context.add(new WeatherVariables());
        this.context.add(new StateVariables());
        this.context.add(new SeasonVariables());
    }

    public void tick() {
        this.context.update();
    }

    public boolean check(@Nonnull String conditions) {
        Object result = this.eval(conditions);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public Object eval(@Nonnull String conditions) {
        if (StringUtil.m_14408_((String)conditions)) {
            return true;
        }
        Optional<Object> result = this.context.eval(conditions);
        return result.orElse(false);
    }
}

