/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.scanner;

import dynamiclabs.immersivefx.environs.effects.BlockEffect;
import dynamiclabs.immersivefx.environs.library.BlockStateUtil;
import dynamiclabs.immersivefx.environs.scanner.CuboidScanner;
import dynamiclabs.immersivefx.environs.scanner.ScanContext;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AlwaysOnBlockEffectScanner
extends CuboidScanner {
    public AlwaysOnBlockEffectScanner(@Nonnull ScanContext locus, int range) {
        super(locus, "AlwaysOnBlockEffectScanner", range, 0);
    }

    @Override
    protected boolean interestingBlock(BlockState state) {
        return BlockStateUtil.getData(state).hasAlwaysOnEffects();
    }

    @Override
    public void blockScan(@Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random rand) {
        BlockGetter provider = this.locus.getWorld();
        Collection<BlockEffect> effects = BlockStateUtil.getData(state).getAlwaysOnEffects();
        for (BlockEffect be : effects) {
            if (!be.canTrigger(provider, state, pos, rand)) continue;
            be.doEffect(provider, state, pos, rand);
        }
    }
}

