/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.scanner;

import dynamiclabs.immersivefx.environs.effects.BlockEffect;
import dynamiclabs.immersivefx.environs.library.BlockStateData;
import dynamiclabs.immersivefx.environs.library.BlockStateUtil;
import dynamiclabs.immersivefx.environs.scanner.RandomScanner;
import dynamiclabs.immersivefx.environs.scanner.ScanContext;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RandomBlockEffectScanner
extends RandomScanner {
    private static final int ITERATION_COUNT = 667;
    public static final int NEAR_RANGE = 16;
    public static final int FAR_RANGE = 32;

    public RandomBlockEffectScanner(@Nonnull ScanContext locus, int range) {
        super(locus, "RandomBlockScanner: " + range, range, 667);
    }

    @Override
    protected boolean interestingBlock(@Nonnull BlockState state) {
        return BlockStateUtil.getData(state).hasSoundsOrEffects();
    }

    @Override
    public void blockScan(@Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random rand) {
        BlockGetter world = this.locus.getWorld();
        BlockStateData profile = BlockStateUtil.getData(state);
        Collection<BlockEffect> effects = profile.getEffects();
        for (BlockEffect be : effects) {
            if (!be.canTrigger(world, state, pos, rand)) continue;
            be.doEffect(world, state, pos, rand);
        }
        IAcoustic sound = profile.getSoundToPlay(rand);
        if (sound != null) {
            sound.playAt(pos);
        }
    }
}

