/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.scanner;

import dynamiclabs.immersivefx.environs.scanner.ScanContext;
import dynamiclabs.immersivefx.environs.scanner.Scanner;
import dynamiclabs.immersivefx.lib.random.LCGRandom;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class RandomScanner
extends Scanner {
    private final LCGRandom lcg = new LCGRandom();
    private int playerX;
    private int playerY;
    private int playerZ;

    public RandomScanner(@Nonnull ScanContext locus, @Nonnull String name, int range, int blocksPerTick) {
        super(locus, name, range, blocksPerTick);
    }

    private int randomRange(int range) {
        return this.lcg.nextInt(range) - this.lcg.nextInt(range);
    }

    @Override
    public void preScan() {
        BlockPos pos = this.locus.getCenter();
        this.playerX = pos.m_123341_();
        this.playerY = pos.m_123342_();
        this.playerZ = pos.m_123343_();
    }

    @Override
    @Nonnull
    protected BlockPos nextPos(@Nonnull BlockPos.MutableBlockPos workingPos, @Nonnull Random rand) {
        return workingPos.m_122178_(this.playerX + this.randomRange(this.xRange), this.playerY + this.randomRange(this.yRange), this.playerZ + this.randomRange(this.zRange));
    }
}

