/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.shaders.aurora;

import dynamiclabs.immersivefx.lib.math.MathStuff;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class Panel {
    private static final float COS_DEG90_FACTOR = MathStuff.cos(1.5707964f);
    private static final float COS_DEG270_FACTOR = MathStuff.cos(4.712389f);
    private static final float SIN_DEG90_FACTOR = MathStuff.sin(1.5707964f);
    private float dZ = 0.0f;
    private float dY = 0.0f;
    private float sinDeg90 = 0.0f;
    public final float posX;
    public final float posY;
    public final float posZ;
    public float tetX = 0.0f;
    public float tetX2 = 0.0f;
    public float tetZ = 0.0f;

    public Panel(float x, float y, float z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void translate(float dY, float dZ) {
        this.dZ = dZ;
        this.dY = dY;
        float mZ = this.getModdedZ();
        this.tetZ = mZ + this.sinDeg90;
    }

    public float getModdedZ() {
        return this.posZ + this.dZ;
    }

    public float getModdedY() {
        float y = this.posY + this.dY;
        return MathStuff.max(0.0f, y);
    }

    public void setWidth(float w) {
        float cosDeg270 = COS_DEG270_FACTOR * w;
        float cosDeg90 = COS_DEG90_FACTOR * w;
        this.sinDeg90 = SIN_DEG90_FACTOR * w;
        this.tetX = this.posX + cosDeg90;
        this.tetX2 = this.posX + cosDeg270;
    }
}

