/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import dynamiclabs.immersivefx.lib.Lib;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public final class JsonUtils {
    private JsonUtils() {
    }

    @Nonnull
    public static <T> Map<String, T> loadConfig(@Nonnull ResourceLocation location, final @Nonnull Class<T> clazz) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(clazz);
        String asset = String.format("/assets/%s/%s", location.m_135827_(), location.m_135815_());
        ParameterizedType type = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{String.class, clazz};
            }

            @Override
            public Type getRawType() {
                return Map.class;
            }

            @Override
            @Nullable
            public Type getOwnerType() {
                return null;
            }
        };
        Map result = (Map)JsonUtils.load(type, asset);
        return result != null ? result : ImmutableMap.of();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T load(@Nonnull Type type, @Nonnull String path) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(path);
        try (InputStream stream = JsonUtils.class.getResourceAsStream(path);){
            if (stream == null) return null;
            T t = JsonUtils.load(stream, type);
            return t;
        }
        catch (Throwable t) {
            Lib.LOGGER.error(t, "Unable to load resource [%s] from JAR", path);
        }
        return null;
    }

    @Nonnull
    public static <T> T load(@Nonnull ResourceLocation location, @Nonnull Class<T> clazz) throws Exception {
        String asset = String.format("/assets/%s/%s", location.m_135827_(), location.m_135815_());
        return JsonUtils.load(asset, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static <T> T load(@Nonnull String path, @Nonnull Class<T> clazz) throws Exception {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(path);
        try (InputStream stream = clazz.getResourceAsStream(path);){
            if (stream == null) return clazz.newInstance();
            T t = JsonUtils.load(stream, clazz);
            return t;
        }
        catch (Throwable t) {
            Lib.LOGGER.error(t, "Unable to load resource [%s] from JAR", path);
        }
        return clazz.newInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static <T> T load(@Nonnull InputStream stream, @Nonnull Class<T> clazz) throws Exception {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(clazz);
        try (InputStreamReader reader = new InputStreamReader(stream);){
            Object object = new Gson().fromJson((Reader)reader, clazz);
            return (T)object;
        }
        catch (Throwable t) {
            Lib.LOGGER.error(t, "Unable to process Json from stream", new Object[0]);
            return clazz.newInstance();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T load(@Nonnull InputStream stream, @Nonnull Type type) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(type);
        try (InputStreamReader reader = new InputStreamReader(stream);){
            Object object = new Gson().fromJson((Reader)reader, type);
            return (T)object;
        }
        catch (Throwable t) {
            Lib.LOGGER.error(t, "Unable to process Json from stream", new Object[0]);
            return null;
        }
    }

    @Nullable
    public static <T> T load(@Nonnull String source, @Nonnull Type type) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(type);
        try {
            return (T)new Gson().fromJson(source, type);
        }
        catch (Throwable t) {
            Lib.LOGGER.error(t, "Unable to process Json from string", new Object[0]);
            return null;
        }
    }
}

