/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.effects;

import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.Lib;
import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.lib.effects.EntityEffectManager;
import dynamiclabs.immersivefx.lib.effects.entity.CapabilityEntityFXData;
import dynamiclabs.immersivefx.lib.effects.entity.IEntityFX;
import dynamiclabs.immersivefx.lib.events.DiagnosticEvent;
import dynamiclabs.immersivefx.lib.math.LoggingTimerEMA;
import dynamiclabs.immersivefx.sndctrl.api.effects.AbstractEntityEffect;
import dynamiclabs.immersivefx.sndctrl.config.Config;
import dynamiclabs.immersivefx.sndctrl.library.EntityEffectLibrary;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EntityEffectHandler {
    private static final LoggingTimerEMA timer = new LoggingTimerEMA("Entity Effect Update");
    private static long nanos;

    private EntityEffectHandler() {
    }

    public static void initialize() {
    }

    @Nonnull
    private static Optional<EntityEffectManager> create(@Nonnull LivingEntity entity) {
        ObjectArray<AbstractEntityEffect> effectToApply = EntityEffectLibrary.getEffects(entity);
        EntityEffectManager result = effectToApply.size() > 0 ? new EntityEffectManager(entity, effectToApply) : new EntityEffectManager(entity);
        return Optional.of(result);
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onLivingUpdate(@Nonnull LivingEvent.LivingUpdateEvent event) {
        try {
            LivingEntity entity = event.getEntityLiving();
            if (entity != null && entity.m_20193_().f_46443_) {
                ProfilerFiller profiler = GameUtils.getMC().m_91307_();
                profiler.m_6180_("MobEffects Living Update");
                long start = System.nanoTime();
                CapabilityEntityFXData.getFxInfo((Entity)entity).ifPresent(cap -> {
                    int range = (Integer)Config.CLIENT.effects.effectRange.get();
                    int effectDistSq = range * range;
                    boolean inRange = entity.m_20280_((Entity)GameUtils.getPlayer()) <= (double)effectDistSq;
                    EntityEffectManager mgr = cap.get();
                    if (mgr != null && !inRange) {
                        cap.clear();
                    } else if (mgr == null && inRange && entity.m_6084_()) {
                        cap.set(EntityEffectHandler.create(entity).get());
                    } else if (mgr != null) {
                        mgr.update();
                    }
                });
                nanos += System.nanoTime() - start;
                profiler.m_7238_();
            }
        }
        catch (Throwable t) {
            Lib.LOGGER.error(t, "Error ticking entity %s!", new Object[0]);
        }
    }

    private static void clearHandlers() {
        Iterable entities = GameUtils.getWorld().m_104735_();
        for (Entity e : entities) {
            CapabilityEntityFXData.getFxInfo(e).ifPresent(IEntityFX::clear);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoin(@Nonnull EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_ && GameUtils.getPlayer() == event.getEntity()) {
            EntityEffectHandler.clearHandlers();
        }
    }

    @SubscribeEvent
    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        timer.update(nanos);
        nanos = 0L;
    }

    @SubscribeEvent
    public static void onDiagnostics(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            event.getRenderTimers().add(timer);
        }
    }
}

