/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.fml;

import dynamiclabs.immersivefx.lib.GameUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public final class ForgeUtils {
    private ForgeUtils() {
    }

    @Nonnull
    public static Optional<? extends ModContainer> findModContainer(@Nonnull String modId) {
        return ModList.get().getModContainerById(modId);
    }

    @Nonnull
    public static Optional<IModInfo> getModInfo(@Nonnull String modId) {
        return ForgeUtils.findModContainer(modId).map(ModContainer::getModInfo);
    }

    @Nonnull
    public static String getModDisplayName(@Nonnull String modId) {
        if ("minecraft".equalsIgnoreCase(modId)) {
            return "Minecraft";
        }
        return ForgeUtils.getModInfo(modId).map(IModInfo::getDisplayName).orElse("UNKNOWN");
    }

    @Nonnull
    public static String getModDisplayName(@Nonnull ResourceLocation resource) {
        Objects.requireNonNull(resource);
        return ForgeUtils.getModDisplayName(resource.m_135827_());
    }

    @Nullable
    public static ArtifactVersion getForgeVersion() {
        return ForgeUtils.getModInfo("forge").map(IModInfo::getVersion).orElse(null);
    }

    @Nonnull
    public static List<String> getModIdList() {
        List<String> result = ModList.get().getModFiles().stream().flatMap(e -> e.getMods().stream()).map(IModInfo::getModId).distinct().collect(Collectors.toList());
        result.remove("minecraft");
        result.add(0, "minecraft");
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static Collection<Pack> getEnabledResourcePacks() {
        return GameUtils.getMC().m_91099_().m_10524_();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static List<String> getResourcePackIdList() {
        return ForgeUtils.getEnabledResourcePacks().stream().flatMap(e -> e.m_10445_().m_5698_(PackType.CLIENT_RESOURCES).stream()).collect(Collectors.toList());
    }

    @Nonnull
    public static Collection<Biome> getBiomes() {
        return ForgeRegistries.BIOMES.getValues();
    }

    @Nonnull
    public static Collection<BlockState> getBlockStates() {
        return StreamSupport.stream(ForgeRegistries.BLOCKS.spliterator(), false).map(block -> block.m_49965_().m_61056_()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static boolean isModLoaded(@Nonnull String mod) {
        return ModList.get().isLoaded(mod.toLowerCase());
    }
}

