/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.math;

import dynamiclabs.immersivefx.lib.math.BlockRayTrace;
import dynamiclabs.immersivefx.lib.math.MathStuff;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RayTraceIterator
implements Iterator<BlockHitResult> {
    @Nonnull
    private final BlockRayTrace traceContext;
    @Nonnull
    private final BlockPos targetBlock;
    @Nonnull
    private final Vec3 normal;
    @Nullable
    private BlockHitResult hitResult;

    public RayTraceIterator(@Nonnull BlockRayTrace traceContext) {
        this.traceContext = traceContext;
        this.targetBlock = new BlockPos(traceContext.end);
        this.normal = MathStuff.normalize(traceContext.start, traceContext.end);
        this.doTrace();
    }

    private void doTrace() {
        this.hitResult = this.hitResult != null && this.hitResult.m_82425_().equals((Object)this.targetBlock) ? null : this.traceContext.trace();
    }

    @Override
    public boolean hasNext() {
        return this.hitResult != null && this.hitResult.m_6662_() != HitResult.Type.MISS;
    }

    @Override
    @Nonnull
    public BlockHitResult next() {
        if (this.hitResult == null || this.hitResult.m_6662_() == HitResult.Type.MISS) {
            throw new IllegalStateException("No more blocks in trace");
        }
        BlockHitResult result = this.hitResult;
        this.traceContext.start = this.hitResult.m_82450_().m_82549_(this.normal);
        this.doTrace();
        return result;
    }
}

