/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.scripting.sets;

import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.biomes.BiomeUtilities;
import dynamiclabs.immersivefx.lib.scripting.VariableSet;
import dynamiclabs.immersivefx.lib.scripting.sets.IBiomeVariables;
import dynamiclabs.immersivefx.lib.scripting.sets.LazyVariable;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;

@OnlyIn(value=Dist.CLIENT)
public class BiomeVariables
extends VariableSet<IBiomeVariables>
implements IBiomeVariables {
    private Biome biome;
    private final LazyVariable<Set<BiomeDictionary.Type>> biomeTraits = new LazyVariable<Set>(() -> BiomeDictionary.getTypes((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.biome.getRegistryName())));
    private final LazyVariable<Set<String>> biomeTraitNames = new LazyVariable<Set>(() -> this.biomeTraits.get().stream().map(BiomeDictionary.Type::getName).collect(Collectors.toSet()));
    private final LazyVariable<String> traits = new LazyVariable<String>(() -> String.join((CharSequence)" ", (Iterable<? extends CharSequence>)this.biomeTraitNames.get()));
    private final LazyVariable<String> name = new LazyVariable<String>(() -> BiomeUtilities.getBiomeName(this.biome));
    private final LazyVariable<String> modid = new LazyVariable<String>(() -> this.biome.getRegistryName().m_135827_());
    private final LazyVariable<String> id = new LazyVariable<String>(() -> this.biome.getRegistryName().toString());
    private final LazyVariable<String> category = new LazyVariable<String>(() -> this.biome.m_47567_().m_47645_());
    private final LazyVariable<String> rainType = new LazyVariable<String>(() -> this.biome.m_47530_().m_47731_());

    public BiomeVariables() {
        super("biome");
        this.setBiome((Biome)((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_).m_6246_(Biomes.f_48202_));
    }

    public void setBiome(@Nonnull Biome biome) {
        if (this.biome != biome) {
            this.update();
            this.biome = biome;
        }
    }

    @Override
    @Nonnull
    public IBiomeVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        Biome newBiome = null;
        newBiome = GameUtils.isInGame() ? BiomeUtilities.getClientBiome(GameUtils.getPlayer().m_142538_()) : (Biome)((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_).m_6246_(Biomes.f_48202_);
        if (newBiome != this.biome) {
            this.biome = newBiome;
            this.name.reset();
            this.modid.reset();
            this.id.reset();
            this.category.reset();
            this.rainType.reset();
            this.traits.reset();
            this.biomeTraits.reset();
            this.biomeTraitNames.reset();
        }
    }

    @Override
    public String getModId() {
        return this.modid.get();
    }

    @Override
    public String getId() {
        return this.id.get();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name.get();
    }

    @Override
    public float getRainfall() {
        return this.biome.m_47548_();
    }

    @Override
    public float getTemperature() {
        return this.biome.m_47554_();
    }

    @Override
    public String getCategory() {
        return this.category.get();
    }

    @Override
    public String getRainType() {
        return this.rainType.get();
    }

    @Override
    public String getTraits() {
        return this.traits.get();
    }

    @Override
    public boolean is(@Nonnull String traitName) {
        return this.biomeTraitNames.get().contains(traitName.toUpperCase());
    }

    public boolean is(@Nonnull BiomeDictionary.Type type) {
        return this.biomeTraits.get().contains(type);
    }
}

