/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.footsteps;

import dynamiclabs.immersivefx.lib.math.MathStuff;
import dynamiclabs.immersivefx.mobeffects.config.Config;
import dynamiclabs.immersivefx.mobeffects.footsteps.Association;
import dynamiclabs.immersivefx.mobeffects.footsteps.FootStrikeLocation;
import dynamiclabs.immersivefx.mobeffects.footsteps.Substrate;
import dynamiclabs.immersivefx.mobeffects.footsteps.facade.FacadeHelper;
import dynamiclabs.immersivefx.mobeffects.library.Constants;
import dynamiclabs.immersivefx.mobeffects.library.FootstepLibrary;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.AcousticCompiler;
import dynamiclabs.immersivefx.sndctrl.library.Primitives;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AcousticResolver {
    private static final float PROBE_DEPTH = 0.0625f;
    protected final LevelReader world;
    protected final FootStrikeLocation loc;
    protected final double distanceToCenter;

    public AcousticResolver(@Nonnull LevelReader world, @Nonnull FootStrikeLocation loc, double distanceToCenter) {
        this.world = world;
        this.loc = loc;
        this.distanceToCenter = distanceToCenter;
    }

    protected BlockState getBlockStateFacade(@Nonnull Vec3 pos) {
        return FacadeHelper.resolveState(this.loc.getEntity(), this.getBlockState(pos), this.world, pos, Direction.UP);
    }

    protected BlockState getBlockState(@Nonnull Vec3 pos) {
        return this.world.m_8055_(new BlockPos(pos));
    }

    @Nullable
    public Association findAssociation() {
        if (!((Boolean)Config.CLIENT.footsteps.enableFootstepSounds.get()).booleanValue()) {
            return this.findVanillaAssociation();
        }
        Vec3 pos = this.loc.getStrikePosition();
        Association worked = this.resolve(pos);
        if (worked == null) {
            LivingEntity entity = this.loc.getEntity();
            BlockPos adj = new BlockPos(pos);
            double xdang = (entity.m_20185_() - (double)adj.m_123341_()) * 2.0 - 1.0;
            double zdang = (entity.m_20189_() - (double)adj.m_123343_()) * 2.0 - 1.0;
            if (Math.max(MathStuff.abs(xdang), MathStuff.abs(zdang)) > this.distanceToCenter) {
                boolean isXdangMax;
                boolean bl = isXdangMax = MathStuff.abs(xdang) > MathStuff.abs(zdang);
                worked = isXdangMax ? this.resolve(xdang > 0.0 ? this.loc.east() : this.loc.west()) : this.resolve(zdang > 0.0 ? this.loc.south() : this.loc.north());
                if (worked == null) {
                    worked = isXdangMax ? this.resolve(zdang > 0.0 ? this.loc.south() : this.loc.north()) : this.resolve(xdang > 0.0 ? this.loc.east() : this.loc.west());
                }
            }
        }
        return worked;
    }

    @Nullable
    protected Association findVanillaAssociation() {
        BlockState state;
        BlockPos blockpos1;
        BlockState blockstate;
        int posZ;
        int posY;
        Vec3 pos = this.loc.getStrikePosition();
        int posX = Mth.m_14107_((double)pos.f_82479_);
        BlockPos blockpos = new BlockPos(posX, posY = Mth.m_14107_((double)(pos.f_82480_ - 0.0625)), posZ = Mth.m_14107_((double)pos.f_82481_));
        if (this.world.m_46859_(blockpos) && (blockstate = this.world.m_8055_(blockpos1 = blockpos.m_7495_())).collisionExtendsVertically((BlockGetter)this.world, blockpos1, (Entity)this.loc.getEntity())) {
            blockpos = blockpos1;
        }
        if (!(state = this.world.m_8055_(blockpos)).m_60767_().m_76332_() && !state.m_60795_()) {
            blockstate = this.world.m_8055_(blockpos.m_7494_());
            SoundType soundtype = blockstate.m_60713_(Blocks.f_50125_) ? blockstate.getSoundType(this.world, blockpos, (Entity)this.loc.getEntity()) : state.getSoundType(this.world, blockpos, (Entity)this.loc.getEntity());
            IAcoustic acoustics = Primitives.getVanillaFootstepAcoustic(soundtype);
            return new Association(this.loc, acoustics);
        }
        return null;
    }

    @Nullable
    protected Association resolve(@Nonnull Vec3 vec) {
        IAcoustic acoustics = Constants.EMPTY;
        Vec3 tPos = vec.m_82520_(0.0, 1.0, 0.0);
        BlockState above = this.getBlockState(tPos);
        if (above.m_60767_() != Material.f_76296_) {
            acoustics = FootstepLibrary.getBlockAcoustics(above, Substrate.CARPET);
        }
        if (acoustics == Constants.NOT_EMITTER || acoustics == Constants.EMPTY) {
            IAcoustic foliage;
            BlockState below;
            BlockState in = this.getBlockStateFacade(vec);
            if (in.m_60767_() == Material.f_76296_ && (acoustics = FootstepLibrary.getBlockAcoustics(below = this.getBlockState(tPos = vec.m_82520_(0.0, -1.0, 0.0)), Substrate.FENCE)) != Constants.EMPTY) {
                vec = tPos;
                in = below;
            }
            if (acoustics == Constants.EMPTY) {
                acoustics = FootstepLibrary.getBlockAcoustics(in);
            }
            if (acoustics != Constants.NOT_EMITTER && above.m_60767_() != Material.f_76296_ && (foliage = FootstepLibrary.getBlockAcoustics(above, Substrate.FOLIAGE)) != Constants.NOT_EMITTER) {
                acoustics = AcousticCompiler.combine(acoustics, foliage);
            }
        } else {
            vec = tPos;
        }
        if (acoustics == Constants.NOT_EMITTER) {
            return null;
        }
        return new Association(this.loc.rebase(new BlockPos(vec)), acoustics);
    }
}

