/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.footsteps.accents;

import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.mobeffects.config.Config;
import dynamiclabs.immersivefx.mobeffects.footsteps.accents.IFootstepAccentProvider;
import dynamiclabs.immersivefx.mobeffects.library.ItemData;
import dynamiclabs.immersivefx.mobeffects.library.ItemLibrary;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
class ArmorAccents
implements IFootstepAccentProvider {
    ArmorAccents() {
    }

    @Nullable
    protected IAcoustic resolveArmor(@Nonnull ItemStack stack) {
        ItemData id = ItemLibrary.getItemData(stack);
        if (id.isArmor()) {
            return ((ItemData.ArmorItemData)id).getArmorSound(stack);
        }
        return null;
    }

    protected IAcoustic resolveFootArmor(@Nonnull ItemStack stack) {
        ItemData id = ItemLibrary.getItemData(stack);
        if (id.isArmor()) {
            return ((ItemData.ArmorItemData)id).getFootArmorSound(stack);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.CLIENT.footsteps.enableArmorAccents.get();
    }

    @Override
    public void provide(@Nonnull LivingEntity entity, @Nonnull BlockPos blockPos, @Nonnull BlockState posState, @Nonnull ObjectArray<IAcoustic> acoustics) {
        ItemStack armor = ItemData.effectiveArmorItemStack(entity);
        ItemStack foot = ItemData.footArmorItemStack(entity);
        IAcoustic armorAddon = this.resolveArmor(armor);
        IAcoustic footAddon = this.resolveFootArmor(foot);
        if (armorAddon != null) {
            acoustics.add(armorAddon);
            if (armorAddon == footAddon) {
                footAddon = null;
            }
        }
        if (footAddon != null) {
            acoustics.add(footAddon);
        }
    }
}

