/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.footsteps.facade;

import dynamiclabs.immersivefx.mobeffects.MobEffects;
import dynamiclabs.immersivefx.mobeffects.footsteps.facade.ChiselFacadeAccessor;
import dynamiclabs.immersivefx.mobeffects.footsteps.facade.IFacadeAccessor;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public final class FacadeHelper {
    private static final Map<Block, IFacadeAccessor> crackers = new Reference2ObjectOpenHashMap();

    private static void addAccessor(@Nonnull List<IFacadeAccessor> accessors, @Nonnull IFacadeAccessor accessor) {
        if (accessor.isValid()) {
            MobEffects.LOGGER.info("Facade Accessor: %s", accessor.getName());
            accessors.add(accessor);
        }
    }

    protected FacadeHelper() {
    }

    @Nonnull
    public static BlockState resolveState(@Nonnull LivingEntity entity, @Nonnull BlockState state, @Nonnull LevelReader world, @Nonnull Vec3 pos, @Nullable Direction side) {
        BlockState newState;
        IFacadeAccessor accessor;
        if (crackers.size() > 0 && state.m_60767_() != Material.f_76296_ && (accessor = crackers.get(state.m_60734_())) != null && (newState = accessor.getBlockState(entity, state, (BlockGetter)world, pos, side)) != null) {
            return newState;
        }
        return state;
    }

    static {
        ArrayList<IFacadeAccessor> accessors = new ArrayList<IFacadeAccessor>();
        FacadeHelper.addAccessor(accessors, new ChiselFacadeAccessor());
        if (accessors.size() > 0) {
            block0: for (Block b : ForgeRegistries.BLOCKS) {
                for (IFacadeAccessor accessor : accessors) {
                    if (!accessor.instanceOf(b)) continue;
                    crackers.put(b, accessor);
                    continue block0;
                }
            }
        }
    }
}

