/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.library;

import dynamiclabs.immersivefx.mobeffects.library.Constants;
import dynamiclabs.immersivefx.mobeffects.library.ItemLibrary;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcousticFactory;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.Library;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundInstance;
import dynamiclabs.immersivefx.sndctrl.audio.AudioEngine;
import dynamiclabs.immersivefx.sndctrl.audio.PlayerCenteredSoundInstance;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.NullAcoustic;
import dynamiclabs.immersivefx.sndctrl.library.Primitives;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemData {
    private static final int ACOUSTIC_TYPE_SWING = 0;
    private static final int ACOUSTIC_TYPE_USE = 1;
    private static final int ACOUSTIC_TYPE_EQUIP = 2;
    private static final int ACOUSTIC_TYPE_ARMOR = 3;
    private static final int ACOUSTIC_TYPE_ARMOR_FOOT = 4;
    private static final float OTHER_PLAYER_VOLUME_SCALE = 0.75f;
    private final String name;
    private final ResourceLocation swing;
    private final ResourceLocation use;
    private final ResourceLocation equip;
    protected final IAcoustic[] acoustics = new IAcoustic[5];

    ItemData(@Nonnull String name, @Nonnull ResourceLocation sound) {
        this(name, sound, sound, sound);
    }

    ItemData(@Nonnull String name, @Nonnull ResourceLocation swing, @Nonnull ResourceLocation use, @Nonnull ResourceLocation equip) {
        this.name = name;
        this.swing = swing;
        this.use = use;
        this.equip = equip;
    }

    private IAcoustic resolveToolbarAcoustic(int type, @Nonnull ResourceLocation loc) {
        IAcoustic acoustic = this.acoustics[type];
        if (acoustic == null) {
            acoustic = Library.resolve(loc);
            if (acoustic == NullAcoustic.INSTANCE) {
                acoustic = Primitives.getSound(loc, Constants.TOOLBAR);
            }
            this.acoustics[type] = acoustic;
        }
        return acoustic;
    }

    public static ItemStack effectiveArmorItemStack(@Nonnull LivingEntity entity) {
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = entity.m_6844_(EquipmentSlot.LEGS);
        ItemData chestItemData = ItemLibrary.getItemData(chest);
        ItemData legsItemData = ItemLibrary.getItemData(legs);
        int chestPriority = chestItemData.isArmor() ? ((ArmorItemData)chestItemData).getPriority() : -1;
        int legPriority = legsItemData.isArmor() ? ((ArmorItemData)legsItemData).getPriority() : -1;
        return chestPriority > legPriority ? chest.m_41777_() : legs.m_41777_();
    }

    public static ItemStack footArmorItemStack(@Nonnull LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.FEET);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void playSwingSound() {
        this.playSwingSound(null);
    }

    public void playSwingSound(@Nullable BlockPos pos) {
        this.play(0, this.swing, pos);
    }

    public void playUseSound() {
        this.playUseSound(null);
    }

    public void playUseSound(@Nullable BlockPos pos) {
        this.play(1, this.use, pos);
    }

    public void playEquipSound() {
        this.playEquipSound(null);
    }

    public void playEquipSound(@Nullable BlockPos pos) {
        this.play(2, this.equip, pos);
    }

    public boolean isArmor() {
        return this instanceof ArmorItemData;
    }

    protected void play(int type, @Nonnull ResourceLocation loc, @Nullable BlockPos pos) {
        IAcoustic acoustic = this.resolveToolbarAcoustic(type, loc);
        IAcousticFactory factory = acoustic.getFactory(Constants.WALK);
        if (factory != null) {
            ISoundInstance sound;
            if (pos == null) {
                sound = new PlayerCenteredSoundInstance(factory.createSound(), Constants.TOOLBAR);
            } else {
                sound = factory.createSoundAt(pos);
                sound.scaleVolume(0.75f);
            }
            AudioEngine.play(sound);
        }
    }

    public static class ArmorItemData
    extends ItemData {
        private final ResourceLocation armor;
        private final ResourceLocation foot;
        private final int priority;

        ArmorItemData(@Nonnull String name, @Nonnull ResourceLocation item, @Nonnull ResourceLocation armor, @Nonnull ResourceLocation foot, int priority) {
            super(name, item);
            this.armor = armor;
            this.foot = foot;
            this.priority = priority;
        }

        @Nonnull
        public IAcoustic getArmorSound(@Nonnull ItemStack stack) {
            return this.resolveArmorAcoustic(3, this.armor, stack);
        }

        @Nonnull
        public IAcoustic getFootArmorSound(@Nonnull ItemStack stack) {
            return this.resolveArmorAcoustic(4, this.foot, stack);
        }

        public int getPriority() {
            return this.priority;
        }

        private IAcoustic resolveArmorAcoustic(int type, @Nonnull ResourceLocation loc, @Nonnull ItemStack stack) {
            IAcoustic acoustic = NullAcoustic.INSTANCE;
            Item item = stack.m_41720_();
            if (item instanceof ArmorItem && (acoustic = this.acoustics[type]) == null) {
                acoustic = Library.resolve(loc);
                if (acoustic == NullAcoustic.INSTANCE) {
                    acoustic = Primitives.getArmorAccentAcoustic(((ArmorItem)item).m_40401_());
                }
                this.acoustics[type] = acoustic;
            }
            return acoustic;
        }
    }
}

