/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.library.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import dynamiclabs.immersivefx.lib.validation.IValidator;
import dynamiclabs.immersivefx.lib.validation.ValidationException;
import dynamiclabs.immersivefx.lib.validation.ValidationHelpers;
import dynamiclabs.immersivefx.mobeffects.MobEffects;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityConfig
implements IValidator<EntityConfig> {
    @SerializedName(value="effects")
    public String effects = "";
    @SerializedName(value="variator")
    public String variator = "default";
    @SerializedName(value="blockedSounds")
    public List<String> blockedSounds = ImmutableList.of();

    @Override
    public void validate(@Nonnull EntityConfig obj) throws ValidationException {
        ValidationHelpers.notNullOrWhitespace("effects", this.effects, x$0 -> MobEffects.LOGGER.warn((String)x$0, new Object[0]));
        ValidationHelpers.notNullOrWhitespace("variator", this.variator, x$0 -> MobEffects.LOGGER.warn((String)x$0, new Object[0]));
        for (String s : this.blockedSounds) {
            ValidationHelpers.isProperResourceLocation("blockedSounds", s, x$0 -> MobEffects.LOGGER.warn((String)x$0, new Object[0]));
        }
    }
}

