/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.audio;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.audio.Library;
import com.mojang.blaze3d.audio.Listener;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.compat.ModEnvironment;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import dynamiclabs.immersivefx.sndctrl.SoundControl;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundInstance;
import dynamiclabs.immersivefx.sndctrl.audio.handlers.SoundFXProcessor;
import dynamiclabs.immersivefx.sndctrl.config.Config;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.SOFTHRTF;

@OnlyIn(value=Dist.CLIENT)
public final class SoundUtils {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(SoundUtils.class);
    private static final String[] HRTF_STATUS = new String[]{"ALC_HRTF_DISABLED_SOFT", "ALC_HRTF_ENABLED_SOFT", "ALC_HRTF_DENIED_SOFT", "ALC_HRTF_REQUIRED_SOFT", "ALC_HRTF_HEADPHONES_DETECTED_SOFT", "ALC_HRTF_UNSUPPORTED_FORMAT_SOFT"};
    private static int MAX_SOUNDS = 0;
    private static int SOUND_LIMIT = 255;
    private static final Map<String, SoundSource> categoryMapper = new Object2ObjectOpenHashMap();
    private static final Map<SoundInstance, ChannelAccess.ChannelHandle> playing;
    private static final Map<SoundInstance, Integer> delayed;
    private static final Listener listener;
    private static final String COMPAT_FAILURE_MESSAGE = "===============================================================================================\n%s is installed and can cause conflicts with ImmersiveFX.\nImmersiveFX enhanced sound processing will be disabled.\n===============================================================================================";

    private SoundUtils() {
    }

    public static int getMaxSounds() {
        return MAX_SOUNDS;
    }

    public static boolean hasRoom() {
        return SoundUtils.getTotalPlaying() < SOUND_LIMIT;
    }

    static int getTotalPlaying() {
        return playing.size() + delayed.size();
    }

    @Nonnull
    static Map<SoundInstance, ChannelAccess.ChannelHandle> getPlayingSounds() {
        return playing;
    }

    @Nonnull
    static Map<SoundInstance, Integer> getDelayedSounds() {
        return delayed;
    }

    @Nullable
    public static SoundSource getSoundCategory(@Nonnull String name) {
        return categoryMapper.get(Objects.requireNonNull(name));
    }

    public static float getMasterGain() {
        return listener.m_83744_();
    }

    public static boolean isSoundVolumeBlocked(@Nonnull SoundInstance sound) {
        Objects.requireNonNull(sound);
        return SoundUtils.getMasterGain() <= 0.0f || !sound.m_7784_() && sound.m_7769_() <= 0.0f;
    }

    public static boolean inRange(@Nonnull Vec3 listener, @Nonnull SoundInstance sound, int pad) {
        if (sound.m_7796_() || sound.m_7438_() == SoundInstance.Attenuation.NONE) {
            return true;
        }
        int distSq = sound.m_5891_().m_119798_() + pad;
        distSq *= distSq;
        return listener.m_82531_(sound.m_7772_(), sound.m_7780_(), sound.m_7778_()) < (double)distSq;
    }

    public static boolean inRange(@Nonnull Vec3 listener, @Nonnull SoundInstance sound) {
        return SoundUtils.inRange(listener, sound, 0);
    }

    @Nonnull
    public static String debugString(@Nullable SoundInstance sound) {
        if (sound == null) {
            return "null";
        }
        if (sound instanceof ISoundInstance) {
            return sound.toString();
        }
        return MoreObjects.toStringHelper((Object)sound).addValue((Object)sound.m_7904_().toString()).addValue((Object)sound.m_8070_().toString()).addValue((Object)sound.m_7438_().toString()).add("v", sound.m_7769_()).add("p", sound.m_7783_()).add("x", sound.m_7772_()).add("y", sound.m_7780_()).add("z", sound.m_7778_()).add("distance", sound.m_5891_().m_119798_()).add("streaming", sound.m_5891_().m_119796_()).add("global", sound.m_7796_()).toString();
    }

    public static void initialize(@Nonnull Library soundSystem) {
        try {
            long device = soundSystem.f_193465_;
            boolean hasFX = false;
            if (SoundUtils.doEnhancedSounds()) {
                LOGGER.info("Enhanced sounds are enabled.  Will perform sound engine reconfiguration.", new Object[0]);
                ALCCapabilities deviceCaps = ALC.createCapabilities((long)device);
                hasFX = deviceCaps.ALC_EXT_EFX;
                if (!hasFX) {
                    LOGGER.warn("EFX audio extensions not available for the current sound device!", new Object[0]);
                } else {
                    int[] attributes = new int[]{131075, 4, 0};
                    long ctx = ALC10.alcCreateContext((long)device, (int[])attributes);
                    ALC10.alcMakeContextCurrent((long)ctx);
                    AL10.alEnable((int)512);
                    if (deviceCaps.ALC_SOFT_HRTF) {
                        int status = ALC10.alcGetInteger((long)device, (int)6547);
                        LOGGER.info("HRTF status report before configuration: %s", HRTF_STATUS[status]);
                        if (status == 0 && ((Boolean)Config.CLIENT.sound.enableHRTF.get()).booleanValue()) {
                            boolean result = SOFTHRTF.alcResetDeviceSOFT((long)device, (int[])new int[]{6546, 1, 0});
                            if (result) {
                                status = ALC10.alcGetInteger((long)device, (int)6547);
                                LOGGER.warn("After configuration OpenAL reports HRTF status %s", HRTF_STATUS[status]);
                            } else {
                                LOGGER.warn("Unable to set HRTF feature in OpenAL", new Object[0]);
                            }
                        } else {
                            LOGGER.info("HRTF is already configured or ImmersiveFX is not configured to enable", new Object[0]);
                        }
                    }
                }
            }
            MAX_SOUNDS = ALC11.alcGetInteger((long)device, (int)4112);
            SOUND_LIMIT = MAX_SOUNDS - 10;
            if (hasFX) {
                SoundFXProcessor.initialize();
            }
            String vendor = AL10.alGetString((int)45057);
            String version = AL10.alGetString((int)45058);
            String renderer = AL10.alGetString((int)45059);
            String extensions = AL10.alGetString((int)45060);
            LOGGER.info("Vendor: %s", vendor);
            LOGGER.info("Version: %s", version);
            LOGGER.info("Renderer: %s", renderer);
            LOGGER.info("Extensions: %s", extensions);
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), new Object[0]);
            LOGGER.warn("OpenAL special effects for sounds will not be available", new Object[0]);
        }
    }

    private static boolean doEnhancedSounds() {
        if (ModEnvironment.SoundFilters.isLoaded()) {
            LOGGER.warn(COMPAT_FAILURE_MESSAGE, "Sound Filters");
            return false;
        }
        if (ModEnvironment.SoundPhysics.isLoaded()) {
            LOGGER.warn(COMPAT_FAILURE_MESSAGE, "SoundPhysics");
            return false;
        }
        if (!((Boolean)Config.CLIENT.sound.enableEnhancedSounds.get()).booleanValue()) {
            LOGGER.warn("Enhanced sounds are not enabled.  No fancy sounds for you!", new Object[0]);
            return false;
        }
        return true;
    }

    public static void deinitialize(@Nonnull Library soundSystem) {
        SoundFXProcessor.deinitialize();
    }

    static {
        for (SoundSource sc : SoundSource.values()) {
            categoryMapper.put(sc.m_12676_(), sc);
        }
        SoundEngine engine = GameUtils.getSoundHander().f_120349_;
        playing = engine.f_120226_;
        delayed = engine.f_120229_;
        listener = engine.f_120221_;
    }
}

