/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.audio.acoustic;

import dynamiclabs.immersivefx.lib.random.XorShiftRandom;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcousticFactory;
import dynamiclabs.immersivefx.sndctrl.api.sound.Category;
import dynamiclabs.immersivefx.sndctrl.api.sound.IFadableSoundInstance;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundCategory;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundInstance;
import dynamiclabs.immersivefx.sndctrl.api.sound.SoundBuilder;
import dynamiclabs.immersivefx.sndctrl.audio.BackgroundSoundInstance;
import dynamiclabs.immersivefx.sndctrl.audio.DSSoundInstance;
import dynamiclabs.immersivefx.sndctrl.audio.EntitySoundInstance;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AcousticFactory
extends SoundBuilder
implements IAcousticFactory {
    public static final int SOUND_RANGE = 16;
    private static final Random RANDOM = new XorShiftRandom();

    public AcousticFactory(@Nonnull SoundEvent event) {
        super(event, Category.AMBIENT);
    }

    public AcousticFactory(@Nonnull SoundEvent event, @Nonnull ISoundCategory category) {
        super(event, category);
    }

    private static Vec3 randomPoint(int minRange, int maxRange) {
        double x = RANDOM.nextDouble() - 0.5;
        double y = RANDOM.nextDouble() - 0.5;
        double z = RANDOM.nextDouble() - 0.5;
        Vec3 vec = new Vec3(x, y, z).m_82541_();
        int range = maxRange - minRange;
        double magnitude = range <= 0 ? (double)minRange : (double)minRange + RANDOM.nextDouble() * (double)range;
        return vec.m_82490_(magnitude);
    }

    @Override
    @Nonnull
    public ISoundInstance createSound() {
        return this.createSoundAt(BlockPos.f_121853_);
    }

    @Override
    @Nonnull
    public ISoundInstance createSoundAt(@Nonnull BlockPos pos) {
        DSSoundInstance sound = this.makeSound();
        sound.setPosition((Vec3i)pos);
        return sound;
    }

    @Override
    @Nonnull
    public ISoundInstance createSoundAt(@Nonnull Vec3 pos) {
        DSSoundInstance sound = this.makeSound();
        sound.setPosition(pos);
        return sound;
    }

    @Override
    @Nonnull
    public ISoundInstance createSoundNear(@Nonnull Entity entity) {
        return this.createSoundNear(entity, 0, 16);
    }

    @Override
    @Nonnull
    public ISoundInstance createSoundNear(@Nonnull Entity entity, int minRange, int maxRange) {
        Vec3 offset = AcousticFactory.randomPoint(minRange, maxRange);
        float posX = (float)(entity.m_20185_() + offset.m_7096_());
        float posY = (float)(entity.m_20186_() + (double)entity.m_20192_() + offset.m_7098_());
        float posZ = (float)(entity.m_20189_() + offset.m_7094_());
        DSSoundInstance sound = this.makeSound();
        sound.setPosition(posX, posY, posZ);
        return sound;
    }

    @Override
    @Nonnull
    public ISoundInstance attachSound(@Nonnull Entity entity) {
        return new EntitySoundInstance(entity, this.makeSound());
    }

    @Override
    @Nonnull
    public IFadableSoundInstance createBackgroundSound() {
        return new BackgroundSoundInstance(this.createSound());
    }
}

