/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.library;

import com.google.gson.reflect.TypeToken;
import dynamiclabs.immersivefx.lib.Utilities;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import dynamiclabs.immersivefx.lib.resource.IResourceAccessor;
import dynamiclabs.immersivefx.lib.resource.ResourceUtils;
import dynamiclabs.immersivefx.lib.validation.MapValidator;
import dynamiclabs.immersivefx.lib.validation.Validators;
import dynamiclabs.immersivefx.sndctrl.SoundControl;
import dynamiclabs.immersivefx.sndctrl.api.sound.Category;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundCategory;
import dynamiclabs.immersivefx.sndctrl.audio.SoundMetadata;
import dynamiclabs.immersivefx.sndctrl.audio.handlers.SoundProcessor;
import dynamiclabs.immersivefx.sndctrl.config.Config;
import dynamiclabs.immersivefx.sndctrl.library.IndividualSoundConfig;
import dynamiclabs.immersivefx.sndctrl.library.config.SoundMetadataConfig;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public final class SoundLibrary {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(SoundLibrary.class);
    private static final ResourceLocation MISSING_RESOURCE = new ResourceLocation("sndctrl", "missing_sound");
    private static final Object2ObjectOpenHashMap<ResourceLocation, SoundEvent> myRegistry = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<ResourceLocation, SoundMetadata> soundMetadata = new Object2ObjectOpenHashMap();
    private static final Type SOUND_FILE_TYPE = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, SoundMetadataConfig.class}).getType();
    public static final SoundEvent MISSING = new SoundEvent(MISSING_RESOURCE);

    private SoundLibrary() {
    }

    public static void initialize() {
        ForgeRegistries.SOUND_EVENTS.forEach(se -> myRegistry.put((Object)se.m_11660_(), se));
        Collection<IResourceAccessor> soundFiles = ResourceUtils.findSounds();
        for (IResourceAccessor file : soundFiles) {
            SoundLibrary.registerSoundFile(file);
        }
        LOGGER.info("Number of SoundEvents cached: %d", myRegistry.size());
        LOGGER.info("Individual Sound Configurations", new Object[0]);
        LOGGER.info("===============================", new Object[0]);
        SoundLibrary.getIndividualSoundConfig().forEach(cfg -> LOGGER.info(cfg.toString(), new Object[0]));
        LOGGER.info("Category Occlusion", new Object[0]);
        LOGGER.info("==================", new Object[0]);
        Category.getCategories().forEach(c -> LOGGER.info("%s -> %s", c.getName(), c.doOcclusion()));
    }

    static List<IndividualSoundConfig> getIndividualSoundConfig() {
        return ((List)Config.CLIENT.sound.individualSounds.get()).stream().map(IndividualSoundConfig::createFrom).filter(Objects::nonNull).filter(e -> !e.isDefault()).collect(Collectors.toList());
    }

    @Nonnull
    public static Collection<IndividualSoundConfig> getSortedSoundConfigurations() {
        TreeMap<ResourceLocation, IndividualSoundConfig> map = new TreeMap<ResourceLocation, IndividualSoundConfig>();
        for (Map.Entry kvp : myRegistry.entrySet()) {
            map.put((ResourceLocation)kvp.getKey(), new IndividualSoundConfig((SoundEvent)kvp.getValue()));
        }
        SoundLibrary.getIndividualSoundConfig().forEach(cfg -> map.put(cfg.getLocation(), new IndividualSoundConfig((IndividualSoundConfig)cfg)));
        Comparator<IndividualSoundConfig> iscComparator = Comparator.comparing(isc -> isc.getLocation().toString());
        return map.values().stream().sorted(iscComparator).collect(Collectors.toList());
    }

    public static void updateSoundConfigurations(@Nonnull Collection<IndividualSoundConfig> configs) {
        List items = configs.stream().map(Object::toString).collect(Collectors.toList());
        Config.CLIENT.sound.individualSounds.set(items);
        SoundProcessor.applyConfig();
    }

    private static void registerSoundFile(@Nonnull IResourceAccessor soundFile) {
        Map result = (Map)soundFile.as(SOUND_FILE_TYPE);
        if (result != null && result.size() > 0) {
            ResourceLocation resource = soundFile.location();
            LOGGER.debug("Processing %s", resource);
            result.forEach((key, value) -> {
                ResourceLocation loc = new ResourceLocation(resource.m_135827_(), key);
                if (!myRegistry.containsKey((Object)loc)) {
                    myRegistry.put((Object)loc, (Object)new SoundEvent(loc));
                }
                if (!value.isDefault()) {
                    SoundMetadata data = new SoundMetadata((SoundMetadataConfig)value);
                    soundMetadata.put((Object)loc, (Object)data);
                }
            });
        } else {
            LOGGER.debug("Skipping %s - unable to parse sound file or there are no sounds declared", soundFile.location());
        }
    }

    @Nonnull
    public static Optional<SoundEvent> getSound(@Nonnull ResourceLocation sound) {
        Objects.requireNonNull(sound);
        SoundEvent se = (SoundEvent)myRegistry.get((Object)sound);
        if (se == MISSING) {
            SoundControl.LOGGER.warn("Unable to locate sound '%s'", sound.toString());
        }
        return Optional.of(se);
    }

    @Nonnull
    public static SoundMetadata getSoundMetadata(@Nonnull ResourceLocation sound) {
        return (SoundMetadata)soundMetadata.get((Object)Objects.requireNonNull(sound));
    }

    @Nonnull
    public static ISoundCategory getSoundCategory(@Nonnull ResourceLocation sound, @Nonnull ISoundCategory defaultCategory) {
        return Utilities.firstNonNull(((SoundMetadata)soundMetadata.get((Object)Objects.requireNonNull(sound))).getCategory(), defaultCategory);
    }

    static {
        myRegistry.defaultReturnValue((Object)MISSING);
        soundMetadata.defaultReturnValue((Object)new SoundMetadata());
        Validators.registerValidator(SOUND_FILE_TYPE, new MapValidator());
    }
}

