/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.material.Material;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import potionstudios.byg.BYGConstants;
import potionstudios.byg.common.BYGCarvableBlocks;
import potionstudios.byg.common.BYGCompostables;
import potionstudios.byg.common.BYGFlammables;
import potionstudios.byg.common.BYGFlattenables;
import potionstudios.byg.common.BYGHoeables;
import potionstudios.byg.common.BYGStrippables;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.entity.ai.village.poi.BYGPoiTypes;
import potionstudios.byg.common.entity.villager.BYGVillagerType;
import potionstudios.byg.common.world.structure.BYGStructureFeature;
import potionstudios.byg.common.world.structure.WithGenerationStep;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.data.BYGDataProviders;
import potionstudios.byg.mixin.access.BlockEntityTypeAccess;
import potionstudios.byg.mixin.access.DeltaFeatureAccess;
import potionstudios.byg.mixin.access.PoiTypeAccess;
import potionstudios.byg.mixin.access.StructureFeatureAccess;
import potionstudios.byg.mixin.access.WorldCarverAccess;
import potionstudios.byg.reg.BlockRegistryObject;
import potionstudios.byg.reg.RegistryObject;
import potionstudios.byg.server.command.ReloadConfigsCommand;
import potionstudios.byg.server.command.UpdateConfigsCommand;
import potionstudios.byg.server.command.WorldGenExportCommand;
import potionstudios.byg.util.FileUtils;
import potionstudios.byg.util.ModPlatform;

public class BYG {
    public static final String MOD_ID = "byg";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean INITIALIZED;

    public static void commonLoad() {
        LOGGER.debug("BYG: \"Common Setup\" Event Starting...");
        for (WorldCarver worldCarver : Registry.f_122837_) {
            WorldCarverAccess carverAccess = (WorldCarverAccess)worldCarver;
            carverAccess.setReplaceableBlocks((Set<Block>)new ImmutableSet.Builder().addAll((Iterable)BYGCarvableBlocks.addCarverBlocks().get()).addAll(carverAccess.byg_getReplaceableBlocks()).build());
        }
        LOGGER.info("BYG: \"Common Setup\" Event Complete!");
        PoiTypeAccess.byg_invokeRegisterBlockStates(BYGPoiTypes.FORAGER.get());
        BYGStructureFeature.PROVIDER.getEntries().stream().map(RegistryObject::get).filter(WithGenerationStep.class::isInstance).forEach(f -> StructureFeatureAccess.byg_getSTEP().put((StructureFeature<?>)f, ((WithGenerationStep)f).getDecoration()));
        String loadAllConfigs = BYGConfigHandler.loadAllConfigs(false, false);
        if (!loadAllConfigs.isEmpty()) {
            throw new IllegalStateException(loadAllConfigs);
        }
        FileUtils.backUpDirectory(ModPlatform.INSTANCE.configPath(), "last_working_configs_backup");
    }

    public static void attachCommands(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environmentType) {
        WorldGenExportCommand.worldGenExportCommand(dispatcher);
        LiteralArgumentBuilder bygCommands = Commands.m_82127_((String)MOD_ID);
        bygCommands.then(ReloadConfigsCommand.register());
        bygCommands.then(UpdateConfigsCommand.register());
        dispatcher.register(bygCommands);
    }

    public static void threadSafeCommonLoad() {
        if (BYGConstants.GENERATE_DATA) {
            BYGDataProviders.generateProviders();
        }
        BYGVillagerType.setVillagerForBYGBiomes();
        BYG.appendBlocksToBlockEntities();
        DeltaFeatureAccess.byg_setCANNOT_REPLACE((ImmutableList<Block>)new ImmutableList.Builder().addAll(DeltaFeatureAccess.byg_getCANNOT_REPLACE()).add((Object)((Block)BYGBlocks.EMBUR_GEL_BLOCK.get())).add((Object)((Block)BYGBlocks.EMBUR_GEL_BRANCH.get())).add((Object)((Block)BYGBlocks.EMBUR_GEL_VINES.get())).addAll((Iterable)Util.m_137469_(new ArrayList(), list -> {
            for (Block block : Registry.f_122824_) {
                Material material = block.m_49966_().m_60767_();
                if (material != Material.f_76300_ && material != Material.f_76271_ && material != Material.f_76270_ && material != Material.f_76302_ && material != Material.f_76303_ && material != Material.f_76304_ && material != Material.f_76274_ && material != Material.f_76320_ && material != Material.f_76315_) continue;
                list.add(block);
            }
        })).build());
    }

    private static void appendBlocksToBlockEntities() {
        BlockEntityTypeAccess campfireBuilderAccess = (BlockEntityTypeAccess)BlockEntityType.f_58911_;
        ObjectOpenHashSet validCampfireBlocks = new ObjectOpenHashSet(campfireBuilderAccess.byg_getValidBlocks());
        validCampfireBlocks.add((Block)BYGBlocks.CRYPTIC_CAMPFIRE.get());
        validCampfireBlocks.add((Block)BYGBlocks.BORIC_CAMPFIRE.get());
        campfireBuilderAccess.byg_setValidBlocks((Set<Block>)validCampfireBlocks);
        BlockEntityTypeAccess signBuilderAccess = (BlockEntityTypeAccess)BlockEntityType.f_58924_;
        ObjectOpenHashSet signValidBlocks = new ObjectOpenHashSet(signBuilderAccess.byg_getValidBlocks());
        for (BlockRegistryObject<Block> signBlock : BYGBlocks.SIGN_BLOCKS) {
            Block block = (Block)signBlock.get();
            if (block instanceof SignBlock) {
                signValidBlocks.add(block);
                continue;
            }
            throw new IllegalArgumentException("Attempting to add block to sign block entity that is not a type of SignBlock");
        }
        signBuilderAccess.byg_setValidBlocks((Set<Block>)signValidBlocks);
    }

    public static void threadSafeLoadFinish() {
        LOGGER.debug("BYG: \"Load Complete Event\" Starting...");
        BYGCompostables.compostablesBYG();
        BYGHoeables.tillablesBYG();
        BYGFlammables.flammablesBYG();
        BYGStrippables.strippableLogsBYG();
        BYGCarvableBlocks.addCarverBlocks();
        BYGFlattenables.addFlattenables();
        LOGGER.info("BYG: \"Load Complete\" Event Complete!");
    }

    public static ResourceLocation createLocation(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation createLocation(ResourceKey<?> path) {
        return path.m_135782_();
    }

    public static ResourceLocation createLocation(Holder<?> holder) {
        return BYG.createLocation((ResourceKey)holder.m_203543_().orElseThrow());
    }

    static {
        ConfigVersionTracker.getConfig(new ConfigVersionTracker(ModPlatform.INSTANCE.configPath().toFile().exists() ? 0 : 4), false);
    }
}

