/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.blockentity;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import potionstudios.byg.client.gui.HypogealImperiumContainer;
import potionstudios.byg.common.block.nether.HypogealImperiumBlock;
import potionstudios.byg.common.blockentity.BYGBlockEntities;
import potionstudios.byg.common.item.BYGItems;

public class HypogealImperiumBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> contents = NonNullList.m_122780_((int)20, (Object)ItemStack.f_41583_);
    protected int numPlayersUsing;
    protected int crystal = 0;
    public int fuel;
    public int damageTime;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return HypogealImperiumBlockEntity.this.fuel;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            HypogealImperiumBlockEntity.this.fuel = value;
        }

        public int m_6499_() {
            return 1;
        }
    };

    public HypogealImperiumBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(BYGBlockEntities.HYPOGEAL.get(), blockPos, blockState);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbtTag = super.m_5995_();
        nbtTag.m_128405_("Crystal", this.getCrystal());
        nbtTag.m_128376_("Fuel", (short)this.fuel);
        return nbtTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readData(nbt);
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128376_("Fuel", (short)this.fuel);
        compound.m_128405_("Crystal", this.getCrystal());
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.contents);
        }
        super.m_183515_(compound);
    }

    private void readData(CompoundTag nbt) {
        this.contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.fuel = nbt.m_128448_("Fuel");
        this.setCrystal(nbt.m_128451_("Crystal"));
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.contents);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, HypogealImperiumBlockEntity hypogealImperiumBlockEntity) {
        HypogealImperiumBlockEntity.playSound(level, blockPos, blockState, hypogealImperiumBlockEntity);
        HypogealImperiumBlockEntity.addEffectsToMobs(level, blockPos, blockState, hypogealImperiumBlockEntity);
        HypogealImperiumBlockEntity.changeBlocksInRadius(level, blockPos, blockState, hypogealImperiumBlockEntity);
        HypogealImperiumBlockEntity.doCrystalLoad(level, blockPos, blockState, hypogealImperiumBlockEntity);
        HypogealImperiumBlockEntity.addParticles(level, blockPos, blockState, hypogealImperiumBlockEntity);
        HypogealImperiumBlockEntity.setLit(level, blockPos, blockState, hypogealImperiumBlockEntity);
    }

    public static void playSound(Level level, BlockPos blockPos, BlockState blockState, HypogealImperiumBlockEntity hypogealImperiumBlockEntity) {
        if (hypogealImperiumBlockEntity.isLit() && level.m_46467_() % 80L == 0L) {
            level.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11737_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public static void setLit(Level level, BlockPos blockPos, BlockState blockState, HypogealImperiumBlockEntity hypogealImperiumBlockEntity) {
        if (hypogealImperiumBlockEntity.isLit()) {
            level.m_7731_(hypogealImperiumBlockEntity.f_58858_, (BlockState)level.m_8055_(hypogealImperiumBlockEntity.f_58858_).m_61124_((Property)HypogealImperiumBlock.LIT, (Comparable)Boolean.valueOf(hypogealImperiumBlockEntity.isLit())), 3);
            hypogealImperiumBlockEntity.m_6596_();
        }
    }

    public static void doCrystalLoad(Level level, BlockPos blockPos, BlockState blockState, HypogealImperiumBlockEntity hypogealImperiumBlockEntity) {
        ItemStack itemFuelItem = hypogealImperiumBlockEntity.m_8020_(0);
        ItemStack itemCatalystItem = hypogealImperiumBlockEntity.m_8020_(1);
        ItemStack resultItem = hypogealImperiumBlockEntity.m_8020_(2);
        if (hypogealImperiumBlockEntity.getCrystal() < 12) {
            if (itemFuelItem.m_41720_() == BYGItems.SUBZERO_CRYSTAL_SHARD.get() && hypogealImperiumBlockEntity.getFuel() <= 0) {
                hypogealImperiumBlockEntity.setFuel(9);
                itemFuelItem.m_41774_(1);
            }
            if (itemCatalystItem.m_41720_() == BYGItems.SUBZERO_CRYSTAL_CLUSTER.get() && hypogealImperiumBlockEntity.getFuel() > 0) {
                hypogealImperiumBlockEntity.setFuel(hypogealImperiumBlockEntity.getFuel() - 1);
                itemCatalystItem.m_41774_(1);
                hypogealImperiumBlockEntity.setCrystal(hypogealImperiumBlockEntity.getCrystal() + 1);
                hypogealImperiumBlockEntity.m_58904_().m_7260_(hypogealImperiumBlockEntity.f_58858_, hypogealImperiumBlockEntity.m_58900_(), hypogealImperiumBlockEntity.m_58900_(), 13);
                if (resultItem.m_41720_() != BYGItems.SUBZERO_CRYSTAL_CLUSTER.get()) {
                    hypogealImperiumBlockEntity.m_6836_(2, BYGItems.SUBZERO_CRYSTAL_CLUSTER.get().m_7968_());
                }
                if (resultItem.m_41720_() == BYGItems.SUBZERO_CRYSTAL_CLUSTER.get()) {
                    resultItem.m_41764_(resultItem.m_41613_() + 1);
                }
            }
        }
    }

    public static void addParticles(Level level, BlockPos blockPos, BlockState blockState, HypogealImperiumBlockEntity hypogealImperiumBlockEntity) {
        int h = 6 + hypogealImperiumBlockEntity.getCrystal();
        if (level.f_46443_) {
            for (int x1 = hypogealImperiumBlockEntity.m_58899_().m_123341_() - h; x1 <= hypogealImperiumBlockEntity.m_58899_().m_123341_() + h; ++x1) {
                for (int y1 = hypogealImperiumBlockEntity.m_58899_().m_123342_(); y1 <= hypogealImperiumBlockEntity.m_58899_().m_123342_() + 6; ++y1) {
                    for (int z1 = hypogealImperiumBlockEntity.m_58899_().m_123343_() - h; z1 <= hypogealImperiumBlockEntity.m_58899_().m_123343_() + h; ++z1) {
                        Random rand;
                        int i;
                        if (hypogealImperiumBlockEntity.getFuel() <= 0 || (i = (rand = new Random()).nextInt(7)) < 4) continue;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123790_, (double)x1, (double)y1, (double)z1, 0.0, 5.0E-4, 0.0);
                    }
                }
            }
        }
    }

    public static void addEffectsToMobs(Level level, BlockPos blockPos, BlockState blockState, HypogealImperiumBlockEntity hypogealImperiumBlockEntity) {
        if (!level.f_46443_) {
            AABB axisalignedbb = new AABB(hypogealImperiumBlockEntity.f_58858_).m_82400_((double)(6 + hypogealImperiumBlockEntity.getCrystal())).m_82363_(0.0, (double)level.m_141928_(), 0.0);
            List list = level.m_45976_(Monster.class, axisalignedbb);
            for (Monster mob : list) {
                if (hypogealImperiumBlockEntity.getFuel() <= 0) continue;
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 3, false, true));
                --hypogealImperiumBlockEntity.damageTime;
                if (hypogealImperiumBlockEntity.damageTime > 0) continue;
                mob.m_6469_(DamageSource.f_19319_, 2.0f);
                HypogealImperiumBlockEntity.useFuel(level, blockPos, blockState, hypogealImperiumBlockEntity);
                hypogealImperiumBlockEntity.damageTime = 100;
            }
        }
    }

    public static void changeBlocksInRadius(Level level, BlockPos blockPos, BlockState blockState, HypogealImperiumBlockEntity hypogealImperiumBlockEntity) {
        if (!level.f_46443_ && hypogealImperiumBlockEntity.getFuel() > 0) {
            int h = 6 + hypogealImperiumBlockEntity.getCrystal();
            for (int x1 = hypogealImperiumBlockEntity.m_58899_().m_123341_() - h; x1 <= hypogealImperiumBlockEntity.m_58899_().m_123341_() + h; ++x1) {
                for (int y1 = hypogealImperiumBlockEntity.m_58899_().m_123342_() - 2; y1 <= hypogealImperiumBlockEntity.m_58899_().m_123342_() + 5; ++y1) {
                    for (int z1 = hypogealImperiumBlockEntity.m_58899_().m_123343_() - h; z1 <= hypogealImperiumBlockEntity.m_58899_().m_123343_() + h; ++z1) {
                        if (level.m_8055_(new BlockPos(x1, y1, z1)) == Blocks.f_49990_.m_49966_()) {
                            level.m_46597_(new BlockPos(x1, y1, z1), Blocks.f_50126_.m_49966_());
                            HypogealImperiumBlockEntity.useFuel(level, blockPos, blockState, hypogealImperiumBlockEntity);
                        }
                        if (level.m_8055_(new BlockPos(x1, y1, z1)) != Blocks.f_49991_.m_49966_()) continue;
                        level.m_46597_(new BlockPos(x1, y1, z1), Blocks.f_50080_.m_49966_());
                        HypogealImperiumBlockEntity.useFuel(level, blockPos, blockState, hypogealImperiumBlockEntity);
                    }
                }
            }
        }
    }

    public static void useFuel(Level level, BlockPos blockPos, BlockState blockState, HypogealImperiumBlockEntity hypogealImperiumBlockEntity) {
        Random random = new Random();
        int useFuel = random.nextInt(11);
        if (useFuel > 9) {
            hypogealImperiumBlockEntity.setFuel(hypogealImperiumBlockEntity.getFuel() - 1);
        }
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.hypogeal_imperium_container");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new HypogealImperiumContainer(id, player, (Container)this, this.dataAccess);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof HypogealImperiumBlock) {
            this.f_58857_.m_7696_(this.f_58858_, block, 1, this.numPlayersUsing);
            this.f_58857_.m_46672_(this.f_58858_, block);
        }
    }

    public int m_6643_() {
        return 20;
    }

    public int m_6893_() {
        return 64;
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.contents;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.contents = itemsIn;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int amount) {
        this.fuel = amount;
    }

    public int getCrystal() {
        return this.crystal;
    }

    public void setCrystal(int amount) {
        this.crystal = amount;
    }

    private boolean isLit() {
        return this.getFuel() > 0;
    }
}

