/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.FluidState;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class NoisyCaveSphere
extends Feature<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public NoisyCaveSphere(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoisySphereConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (NoisySphereConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoisySphereConfig config) {
        this.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position.m_6625_(2 + random.nextInt(10)));
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable);
        int stackHeight = config.stackHeight().m_142270_(random);
        NoisySphereConfig.RadiusSettings radiusSettings = config.radiusSettings();
        int xRadius = radiusSettings.xRadius().m_142270_(random) / 2;
        int yRadius = radiusSettings.yRadius().m_142270_(random) / 2;
        int zRadius = radiusSettings.zRadius().m_142270_(random) / 2;
        fastNoise.SetFrequency(config.noiseFrequency());
        double radiusDivisorPerStack = config.radiusDivisorPerStack();
        ArrayList<BlockPos> caveAir = new ArrayList<BlockPos>();
        for (int stackIDX = 0; stackIDX < stackHeight; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                for (int z = -zRadius; z <= zRadius; ++z) {
                    for (int y = -yRadius; y <= yRadius; ++y) {
                        mutable2.m_122190_((Vec3i)mutable).m_122184_(x, y, z);
                        double equationResult = Math.pow(x, 2.0) / Math.pow(xRadius, 2.0) + Math.pow(y, 2.0) / Math.pow(yRadius, 2.0) + Math.pow(z, 2.0) / Math.pow(zRadius, 2.0);
                        double threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123342_(), mutable2.m_123343_());
                        if (equationResult >= threshold || !world.m_8055_((BlockPos)mutable2).m_60815_()) continue;
                        if (mutable2.m_123342_() <= 30) {
                            NoisyCaveSphere.placeFluid(world, config.fluidState(), mutable2);
                            continue;
                        }
                        BlockState state = config.blockProvider().m_7112_(random, (BlockPos)mutable2);
                        if (state.m_60795_()) {
                            caveAir.add(mutable2.m_7949_());
                        }
                        world.m_7731_((BlockPos)mutable2, state, 2);
                        for (int i = 0; i < 8; ++i) {
                            BlockState blockState = world.m_8055_((BlockPos)mutable2);
                            if (!blockState.m_60815_() && !blockState.m_60795_() || blockState.m_60713_((Block)BYGBlocks.CRYPTIC_VENT.get()) || blockState.m_60713_((Block)BYGBlocks.TALL_CRYPTIC_VENT.get()) || blockState.m_60713_((Block)BYGBlocks.CRYPTIC_FIRE.get())) {
                                world.m_7471_((BlockPos)mutable2, false);
                            }
                            mutable2.m_122173_(Direction.UP);
                        }
                    }
                    xRadius = (int)((double)xRadius / radiusDivisorPerStack);
                    yRadius = (int)((double)yRadius / radiusDivisorPerStack);
                    zRadius = (int)((double)zRadius / radiusDivisorPerStack);
                }
            }
            for (BlockPos blockPos : caveAir) {
                for (Holder spawningFeature : config.spawningFeatures()) {
                    ((PlacedFeature)spawningFeature.m_203334_()).m_191782_(world, chunkGenerator, random, blockPos);
                }
            }
        }
        return true;
    }

    public static void placeFluid(WorldGenLevel world, FluidState fluidState, BlockPos.MutableBlockPos mutable2) {
        boolean isSolidAllAround = true;
        for (Direction direction : Direction.values()) {
            BlockState blockState;
            if (direction == Direction.UP || (blockState = world.m_8055_(mutable2.m_142300_(direction))).m_60819_().m_76152_() == fluidState.m_76152_() || blockState.m_60815_()) continue;
            isSolidAllAround = false;
            break;
        }
        if (isSolidAllAround) {
            world.m_7731_((BlockPos)mutable2, fluidState.m_76188_().m_60734_().m_49966_(), 2);
            world.m_186469_((BlockPos)mutable2, fluidState.m_76152_(), 0);
        }
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }
}

