/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.Util;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.overworld.BYGOverworldBiomeSelectors;
import potionstudios.byg.common.world.biome.overworld.OverworldRegion;
import potionstudios.byg.shadow.blue.endless.jankson.JsonElement;
import potionstudios.byg.shadow.blue.endless.jankson.api.SyntaxError;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.codec.FromFileOps;
import potionstudios.byg.util.codec.Wrapped;
import potionstudios.byg.util.jankson.JanksonJsonOps;
import potionstudios.byg.util.jankson.JanksonUtil;

public record OverworldBiomeConfig(boolean generateOverworld, List<Wrapped<OverworldRegion>> values) {
    public static final OverworldBiomeConfig DEFAULT = new OverworldBiomeConfig(true, OverworldRegion.OVERWORLD_DEFAULTS);
    public static OverworldBiomeConfig INSTANCE = null;
    public static final Map<String, String> COMMENTS = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put("overworld_enabled", "Global toggle to enable or disable BYG's overworld biomes.");
        map.put("regions", "A list of weighted regions containing a unique biome layout.\nRegions may be inlined or may call a file from \"this_file_parent_directory/regions\"");
    });
    public static final Codec<OverworldBiomeConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("overworld_enabled").forGetter(overworldBiomeConfig -> overworldBiomeConfig.generateOverworld), (App)OverworldRegion.BIOME_PROVIDER_DATA_FROM_FILE_CODEC.listOf().fieldOf("regions").forGetter(overworldBiomeConfig -> overworldBiomeConfig.values)).apply((Applicative)builder, OverworldBiomeConfig::new));
    public static final Codec<List<Wrapped<OverworldRegion>>> FROM_OLD_CODEC_LIST = OverworldRegion.OLD_CODEC.listOf().comapFlatMap(biomeProviderDataList -> {
        ArrayList<Wrapped<OverworldRegion>> wrapped = new ArrayList<Wrapped<OverworldRegion>>();
        for (int i = 0; i < biomeProviderDataList.size(); ++i) {
            OverworldRegion overworldRegion = (OverworldRegion)biomeProviderDataList.get(i);
            String id = "region_" + (i + 1);
            Wrapped<OverworldRegion> dataWrapped = new Wrapped<OverworldRegion>(Optional.of(id), overworldRegion);
            OverworldRegion.BIOME_REGIONS.put(id, (Pair<Map<String, String>, Wrapped<OverworldRegion>>)Pair.of(OverworldRegion.COMMENTS, dataWrapped));
            wrapped.add(dataWrapped);
        }
        return DataResult.success(wrapped);
    }, wrapped -> wrapped.stream().map(Wrapped::value).collect(Collectors.toList()));
    public static final Codec<OverworldBiomeConfig> OLD_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("overworld_enabled").forGetter(overworldBiomeConfig -> overworldBiomeConfig.generateOverworld), (App)FROM_OLD_CODEC_LIST.fieldOf("providers").forGetter(overworldBiomeConfig -> overworldBiomeConfig.values)).apply((Applicative)builder, OverworldBiomeConfig::new));

    public static OverworldBiomeConfig getConfig() {
        return OverworldBiomeConfig.getConfig(false, false);
    }

    public static OverworldBiomeConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = OverworldBiomeConfig.readConfig(recreate);
        }
        return INSTANCE;
    }

    public static void setConfigInstance(OverworldBiomeConfig config) {
        INSTANCE = config;
    }

    private static OverworldBiomeConfig readConfig(boolean recreate) {
        Path path = ModPlatform.INSTANCE.configPath().resolve("overworld").resolve("byg-overworld-biomes.json5");
        OverworldBiomeConfig getOldOrDefault = OverworldBiomeConfig.readAndDeleteOldOverworldConfig(ModPlatform.INSTANCE.configPath().resolve("overworld-biomes.json"), OLD_CODEC, JanksonJsonOps.INSTANCE, DEFAULT);
        if (getOldOrDefault != DEFAULT) {
            BYG.LOGGER.warn("Old overworld config detected, lets try and repair it...");
        }
        FromFileOps.Access registry = new FromFileOps.Access();
        FromFileOps<JsonElement> fromFileOps = new FromFileOps<JsonElement>(JanksonJsonOps.INSTANCE, registry);
        Path regions = path.getParent().resolve("regions");
        Path biomePickers = path.getParent().resolve("biome_selectors");
        try {
            OverworldBiomeConfig.createDefaultsAndRegister(recreate, BYGOverworldBiomeSelectors.BIOME_LAYOUTS, registry.get("biome_layout"), BYGOverworldBiomeSelectors.BIOME_LAYOUT_CODEC, fromFileOps, biomePickers);
            OverworldBiomeConfig.createDefaultsAndRegister(recreate, OverworldRegion.BIOME_REGIONS, registry.get("regions"), OverworldRegion.BIOME_PROVIDER_DATA_FROM_FILE_CODEC, fromFileOps, regions);
            if (!path.toFile().exists() || recreate) {
                JanksonUtil.createConfig(path, CODEC, "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", COMMENTS, fromFileOps, getOldOrDefault);
            }
            OverworldBiomeConfig overworldBiomeConfig = JanksonUtil.readConfig(path, CODEC, fromFileOps);
            BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
            return overworldBiomeConfig;
        }
        catch (IOException | SyntaxError e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T> void createDefaultsAndRegister(boolean recreate, Map<String, Pair<Map<String, String>, T>> defaults, Map<String, T> registry, Codec<T> codec, FromFileOps<JsonElement> fromFileOps, Path providers) throws IOException {
        defaults.forEach((s, listWrapped) -> {
            Path registryPath = providers.resolve(s + ".json5");
            if (!registryPath.toFile().exists() || recreate) {
                JanksonUtil.createConfig(registryPath, codec, ((Map)listWrapped.getFirst()).getOrDefault("", "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/"), (Map)listWrapped.getFirst(), (DynamicOps<JsonElement>)fromFileOps, listWrapped.getSecond());
            }
        });
        Files.walk(providers, new FileVisitOption[0]).forEach(path1 -> {
            String fileName = path1.getFileName().toString();
            if (fileName.endsWith(".json5") || fileName.endsWith(".json")) {
                String relativizedPath = providers.relativize((Path)path1).toString();
                String id = relativizedPath.replace(".json5", "").replace(".json", "").replace("\\", "/");
                try {
                    registry.put(id, JanksonUtil.readConfig(path1, codec, (DynamicOps<JsonElement>)fromFileOps));
                }
                catch (IOException | SyntaxError e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static <T> T readAndDeleteOldOverworldConfig(Path oldPath, Codec<T> codec, DynamicOps<JsonElement> ops, T from) {
        if (oldPath.toFile().exists()) {
            try {
                from = JanksonUtil.readConfig(oldPath, codec, ops);
                Files.delete(oldPath);
            }
            catch (IOException | SyntaxError e) {
                e.printStackTrace();
            }
        }
        return from;
    }
}

