/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.storage.WorldData;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.surfacerules.SurfaceRulesConfig;
import potionstudios.byg.mixin.access.BiomeSourceAccess;
import potionstudios.byg.mixin.access.NoiseBasedChunkGeneratorAccess;
import potionstudios.byg.mixin.access.NoiseGeneratorSettingsAccess;

public class AddSurfaceRulesUtil {
    public static void appendSurfaceRule(WorldData worldData, ResourceKey<LevelStem> levelStemKey, SurfaceRules.RuleSource ruleSource) {
        if (worldData == null) {
            throw new NullPointerException("Minecraft server's world data is null, this should be impossible...");
        }
        LevelStem levelStem = (LevelStem)worldData.m_5961_().m_204655_().m_6246_(levelStemKey);
        if (levelStem == null) {
            BYG.LOGGER.error(String.format("Unable to find level stem/dimension \"%s\", this is most likely due to a world being moved across minecraft versions, Oh The Biomes You'll Go cannot support this operation.\nNot adding surface rules....", levelStemKey));
            return;
        }
        ChunkGenerator chunkGenerator = levelStem.m_63990_();
        boolean hasBYGBiome = chunkGenerator.m_62218_().m_207840_().stream().anyMatch(biomeHolder -> ((ResourceKey)biomeHolder.m_203543_().orElseThrow()).m_135782_().m_135827_().equals("byg"));
        if (hasBYGBiome) {
            Path path = SurfaceRulesConfig.CONFIG_PATHS.get().get(levelStemKey);
            Map<ResourceKey<LevelStem>, SurfaceRules.RuleSource> surfaceRulesConfig = SurfaceRulesConfig.getConfig(true, false);
            if (surfaceRulesConfig.containsKey(levelStemKey) && surfaceRulesConfig.get(levelStemKey) != null) {
                if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                    NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)((NoiseBasedChunkGeneratorAccess)chunkGenerator).byg_getSettings().m_203334_();
                    ((NoiseGeneratorSettingsAccess)noiseGeneratorSettings).byg_setSurfaceRule(SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ruleSource, noiseGeneratorSettings.f_188871_()}));
                } else {
                    BYG.LOGGER.warn(String.format("Ignoring BYG's appended surface rule \"%s\" for dimension: \"%s\" because the chunk generator was not an instance of \"NoiseBasedChunkGenerator\".\nThe chunk generator was an instanceof \"%s\".", path.toString(), levelStemKey.m_135782_(), chunkGenerator.getClass().getName()));
                }
            } else {
                throw new IllegalStateException(String.format("Surface rules for \"%s\" are required to load. Fix the Surface Rule config file found at: \"%s\"", levelStemKey.m_135782_().toString(), path));
            }
        }
        Codec<? extends BiomeSource> biomeSourceCodec = ((BiomeSourceAccess)chunkGenerator.m_62218_()).byg_invokeCodec();
        BYG.LOGGER.info(String.format("Loading dimension \"%s\" with biome source: \"%s\".", levelStemKey.m_135782_().toString(), Registry.f_122889_.m_7981_(biomeSourceCodec).toString()));
    }
}

