/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.mixin.access.WeightedEntryWrapperAccess;
import potionstudios.byg.mixin.access.WeightedListAccess;

public class BYGUtil {
    public static boolean useTagReplacements = false;
    public static final ThreadLocal<RegistryAccess> CAPTURED_REGISTRY_ACCESS = ThreadLocal.withInitial(() -> null);

    public static void captureRegistryAccess(RegistryAccess registryAccess) {
        CAPTURED_REGISTRY_ACCESS.set(registryAccess);
    }

    public static <V> List<List<V>> convert2DArray(V[][] arrayToConvert) {
        ArrayList<List<V>> convertedArrays = new ArrayList<List<V>>();
        for (V[] vs : arrayToConvert) {
            convertedArrays.add(Arrays.asList(vs));
        }
        return convertedArrays;
    }

    public static <T> ResourceKey<T>[][] _2DResourceKeyArrayTo2DList(List<List<ResourceKey<T>>> listToConvert) {
        ArrayList<ResourceKey[]> resultList = new ArrayList<ResourceKey[]>(listToConvert.size());
        for (List<ResourceKey<T>> vs : listToConvert) {
            resultList.add((ResourceKey[])vs.toArray(ResourceKey[]::new));
        }
        return (ResourceKey[][])resultList.toArray(x$0 -> new ResourceKey[x$0][]);
    }

    public static <T> String print2DResourceKeyArray(ResourceKey<T>[][] valueToPrint) {
        StringBuilder builder = new StringBuilder();
        for (ResourceKey<T>[] value : valueToPrint) {
            builder.append(Arrays.toString(Arrays.stream(value).map(ResourceKey::m_135782_).toArray(ResourceLocation[]::new))).append("\n");
        }
        return builder.toString();
    }

    public static <T> String dumpRegistry(Registry<T> registry) {
        StringBuilder registryElements = new StringBuilder();
        for (int i = 0; i < registry.m_6579_().size(); ++i) {
            Object object = registry.m_7942_(i);
            registryElements.append(i).append(". \"").append(registry.m_7981_(object).toString()).append("\"\n");
        }
        return registryElements.toString();
    }

    public static boolean createMarkerFile(Path path, String markerText) {
        if (path.toFile().exists()) {
            return false;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, markerText.getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isNearby(LevelReader levelReader, BlockPos origin, int searchRange, BiPredicate<LevelReader, BlockPos> passes) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (int xOffset = -searchRange; xOffset < searchRange; ++xOffset) {
            for (int yOffset = -searchRange; yOffset < searchRange; ++yOffset) {
                for (int zOffset = -searchRange; zOffset < searchRange; ++zOffset) {
                    mutableBlockPos.m_122190_((Vec3i)origin).m_122184_(xOffset, yOffset, zOffset);
                    if (!passes.test(levelReader, (BlockPos)mutableBlockPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static IOException configFileFailureException(Path path) {
        return new IOException(String.format("BYG config found at: \"%s\" could not be read. The fastest solution is to rename this failed file and let a new file generate from BYG and replace the fields in the new file with the broken file's fields.", path.toFile()));
    }

    public static <T> SimpleWeightedRandomList<T> combineWeightedRandomLists(BiPredicate<Collection<T>, T> filter, SimpleWeightedRandomList<T> ... builders) {
        SimpleWeightedRandomList.Builder combinedBuilder = new SimpleWeightedRandomList.Builder();
        for (SimpleWeightedRandomList<T> build : builders) {
            for (WeightedEntry.Wrapper item : ((WeightedListAccess)build).byg_getItems()) {
                Object data;
                Set collection = ((WeightedListAccess)combinedBuilder.m_146270_()).byg_getItems().stream().map(item1 -> ((WeightedEntryWrapperAccess)item1).byg_getData()).collect(Collectors.toSet());
                if (!filter.test(collection, data = ((WeightedEntryWrapperAccess)item).byg_getData())) continue;
                combinedBuilder.m_146271_(data, ((WeightedEntryWrapperAccess)item).byg_getWeight().m_146281_());
            }
        }
        return combinedBuilder.m_146270_();
    }

    public static List<Holder<Biome>> createBiomesFromBiomeData(Registry<Biome> biomeRegistry, LayersBiomeData ... layersBiomeDatas) {
        ArrayList<Holder<Biome>> biomes = new ArrayList<Holder<Biome>>();
        for (LayersBiomeData layersBiomeData : layersBiomeDatas) {
            ImmutableList items = ((WeightedListAccess)layersBiomeData.biomeWeights()).byg_getItems();
            for (WeightedEntry.Wrapper key : items) {
                ResourceKey resourceKey = (ResourceKey)key.m_146310_();
                Optional biome = biomeRegistry.m_203636_(resourceKey);
                if (biome.isPresent()) {
                    biomes.add((Holder<Biome>)((Holder)biome.get()));
                    continue;
                }
                BYG.LOGGER.info("\"" + resourceKey.m_135782_() + "\" is not a value in the biome registry at this point, ignore this warning if the data pack containing this biome is not yet added during world creation.");
            }
        }
        return biomes;
    }

    public static String dumpCollection(Collection<String> collection) {
        String[] values = (String[])collection.toArray(String[]::new);
        StringBuilder result = new StringBuilder();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            String value = values[i];
            result.append(i + 1).append(". \"");
            if (i < length - 1) {
                result.append(value).append("\",\n");
                continue;
            }
            result.append(value).append("\"");
        }
        return result.toString();
    }

    public static <T, C, V, MAP extends Map<T, V>> MAP convertMapValueType(Map<T, C> from, Supplier<MAP> mapType, Function<C, V> newValueType) {
        Map result = (Map)mapType.get();
        from.forEach((key, oldValue) -> result.put(key, newValueType.apply(oldValue)));
        return (MAP)result;
    }

    public static boolean isInside(int minX, int minY, int maxX, int maxY, int x, int y) {
        return x >= minX && x <= maxX && y >= minY && y <= maxY;
    }

    public static boolean isInside(int minX, int minY, int maxX, int maxY, double x, double y) {
        return x >= (double)minX && x <= (double)maxX && y >= (double)minY && y <= (double)maxY;
    }
}

