/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin {
    @Unique
    private static final ThreadLocal<Map<ScaleType, ScaleData>> pehkui$SCALES = ThreadLocal.withInitial(Object2ObjectLinkedOpenHashMap::new);

    @Inject(method={"drawEntity"}, at={@At(value="HEAD")})
    private static void pehkui$drawEntity$head(int x, int y, int size, float mouseX, float mouseY, LivingEntity entity, CallbackInfo info) {
        Map<ScaleType, ScaleData> scales = pehkui$SCALES.get();
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleData cachedData = scales.computeIfAbsent(type, t -> ScaleData.Builder.create().build());
            ScaleData data = type.getScaleData((Entity)entity);
            cachedData.fromScale(data, false);
            data.resetScale(false);
        }
    }

    @Inject(method={"drawEntity"}, at={@At(value="RETURN")})
    private static void pehkui$drawEntity$return(int x, int y, int size, float mouseX, float mouseY, LivingEntity entity, CallbackInfo info) {
        Map<ScaleType, ScaleData> scales = pehkui$SCALES.get();
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            type.getScaleData((Entity)entity).fromScale(scales.get(type), false);
        }
    }
}

