/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ReflectionUtils;

public class GravityChangerCompatibility {
    private static final boolean GRAVITY_CHANGER_LOADED = ModLoaderUtils.isModLoaded("gravitychanger");
    public static final GravityChangerCompatibility INSTANCE = new GravityChangerCompatibility();
    private final Optional<Class<?>> apiClass;
    private final Optional<Method> getterMethod;
    private final Optional<Class<?>> accessorClass;
    private final Optional<Method> accessorGetterMethod;
    private boolean enabled = GRAVITY_CHANGER_LOADED;

    private GravityChangerCompatibility() {
        if (this.enabled) {
            this.apiClass = ReflectionUtils.getClass("me.andrew.gravitychanger.api.GravityChangerAPI");
            this.getterMethod = ReflectionUtils.getMethod(this.apiClass, "getAppliedGravityDirection", Player.class);
            this.accessorClass = ReflectionUtils.getClass("me.andrew.gravitychanger.accessor.EntityAccessor");
            this.accessorGetterMethod = ReflectionUtils.getMethod(this.accessorClass, "gravitychanger$getAppliedGravityDirection", new Class[0]);
        } else {
            this.apiClass = Optional.empty();
            this.getterMethod = Optional.empty();
            this.accessorClass = Optional.empty();
            this.accessorGetterMethod = Optional.empty();
        }
    }

    public Direction getGravityDirection(Player entity) {
        if (this.enabled) {
            return this.getterMethod.map(m -> {
                try {
                    return (Direction)m.invoke(null, entity);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return Direction.DOWN;
                }
            }).orElseGet(() -> this.accessorGetterMethod.map(m -> {
                try {
                    return (Direction)m.invoke((Object)entity, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return Direction.DOWN;
                }
            }).orElse(Direction.DOWN));
        }
        return Direction.DOWN;
    }

    public float getXCorrection(Player player) {
        if (this.enabled) {
            Direction gravity = this.getGravityDirection(player);
            switch (gravity) {
                case WEST: {
                    return 1.5f;
                }
                case EAST: {
                    return -1.5f;
                }
            }
        }
        return 0.0f;
    }

    public float getYCorrection(Player player) {
        if (this.enabled) {
            Direction gravity = this.getGravityDirection(player);
            switch (gravity) {
                case UP: {
                    return -3.0f;
                }
                case DOWN: {
                    break;
                }
                default: {
                    return -1.5f;
                }
            }
        }
        return 0.0f;
    }

    public float getZCorrection(Player player) {
        if (this.enabled) {
            Direction gravity = this.getGravityDirection(player);
            switch (gravity) {
                case NORTH: {
                    return 1.5f;
                }
                case SOUTH: {
                    return -1.5f;
                }
            }
        }
        return 0.0f;
    }
}

