/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkDirection;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.network.PehkuiPacketHandler;
import virtuoel.pehkui.network.ScalePacket;
import virtuoel.pehkui.util.GravityChangerCompatibility;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

public class ScaleUtils {
    public static final double DEFAULT_MAXIMUM_REACH_BELOW_1_17 = 128.0;
    public static final float DEFAULT_MINIMUM_POSITIVE_SCALE = 1.2621775E-29f;
    public static final float DEFAULT_MAXIMUM_POSITIVE_SCALE = 4.2949673E9f;
    private static final float MINIMUM_LIMB_MOTION_SCALE = 1.2621775E-29f;
    private static final ThreadLocal<Collection<ScaleData>> SYNCED_SCALE_DATA = ThreadLocal.withInitial(ArrayList::new);

    public static void tickScale(ScaleData data) {
        ScaleType type = data.getScaleType();
        type.getPreTickEvent().forEach(s -> s.onEvent(data));
        data.tick();
        type.getPostTickEvent().forEach(s -> s.onEvent(data));
    }

    public static void loadAverageScales(Entity target, Entity source, Entity ... sources) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleData scaleData = type.getScaleData(target);
            ScaleData[] scales = new ScaleData[sources.length];
            for (int i = 0; i < sources.length; ++i) {
                scales[i] = type.getScaleData(sources[i]);
            }
            scaleData.averagedFromScales(type.getScaleData(source), scales);
        }
    }

    public static void loadScaleOnRespawn(Entity target, Entity source, boolean alive) {
        if (alive || ((Boolean)PehkuiConfig.COMMON.keepAllScalesOnRespawn.get()).booleanValue()) {
            ScaleUtils.loadScale(target, source);
            return;
        }
        List keptScales = (List)PehkuiConfig.COMMON.scalesKeptOnRespawn.get();
        for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
            ScaleType type = (ScaleType)entry.getValue();
            ScaleData sourceData = type.getScaleData(source);
            if (!sourceData.shouldPersist() && !keptScales.contains(((ResourceLocation)entry.getKey()).toString())) continue;
            ScaleData targetData = type.getScaleData(target);
            targetData.fromScale(sourceData);
            SortedSet<ScaleModifier> targetModifiers = targetData.getBaseValueModifiers();
            targetModifiers.clear();
            targetModifiers.addAll(sourceData.getBaseValueModifiers());
        }
    }

    public static void loadScale(Entity target, Entity source) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            type.getScaleData(target).fromScale(type.getScaleData(source));
        }
    }

    public static float modifyLimbDistance(float value, Entity entity) {
        float scale = ScaleUtils.getMotionScale(entity);
        if (scale == 1.0f) {
            return value;
        }
        return ScaleUtils.divideClamped(value, scale, 1.2621775E-29f);
    }

    public static float divideClamped(float dividend, float divisor, float limit) {
        float ret = dividend / divisor;
        if (ret == Float.POSITIVE_INFINITY) {
            return limit;
        }
        if (ret == Float.NEGATIVE_INFINITY) {
            return -limit;
        }
        if (ret > limit || ret < -limit) {
            return ret;
        }
        return ret < 0.0f ? -limit : limit;
    }

    public static float setScaleOfDrop(Entity entity, Entity source) {
        return ScaleUtils.setScaleOnSpawn(entity, ScaleUtils.getDropScale(source));
    }

    public static float setScaleOfProjectile(Entity entity, Entity source) {
        return ScaleUtils.setScaleOnSpawn(entity, ScaleUtils.getProjectileScale(source));
    }

    public static float setScaleOnSpawn(Entity entity, float scale) {
        if (scale != 1.0f) {
            ScaleTypes.BASE.getScaleData(entity).setScale(scale);
        }
        return scale;
    }

    public static CompoundTag buildScaleNbtFromPacketByteBuf(FriendlyByteBuf buffer) {
        byte persistent;
        CompoundTag scaleData = new CompoundTag();
        float scale = buffer.readFloat();
        float prevScale = buffer.readFloat();
        float fromScale = buffer.readFloat();
        float toScale = buffer.readFloat();
        int scaleTicks = buffer.readInt();
        int totalScaleTicks = buffer.readInt();
        scaleData.m_128350_("scale", scale);
        scaleData.m_128350_("previous", prevScale);
        scaleData.m_128350_("initial", fromScale);
        scaleData.m_128350_("target", toScale);
        scaleData.m_128405_("ticks", scaleTicks);
        scaleData.m_128405_("total_ticks", totalScaleTicks);
        int baseModifierCount = buffer.readInt();
        if (baseModifierCount != 0) {
            ListTag modifiers = new ListTag();
            for (int i = 0; i < baseModifierCount; ++i) {
                modifiers.add((Object)NbtOps.f_128958_.createString(buffer.m_130136_(Short.MAX_VALUE)));
            }
            scaleData.m_128365_("baseValueModifiers", (Tag)modifiers);
        }
        if ((persistent = buffer.readByte()) != -1) {
            scaleData.m_128379_("persistent", persistent == 1);
        }
        if (buffer.readBoolean()) {
            scaleData.m_128365_("easing", NbtOps.f_128958_.createString(buffer.m_130136_(Short.MAX_VALUE)));
        }
        return scaleData;
    }

    public static void syncScalesIfNeeded(Entity entity, Consumer<Packet<?>> packetSender) {
        if (((PehkuiEntityExtensions)entity).pehkui_shouldSyncScales()) {
            ScaleUtils.syncScales(entity, packetSender, ScaleData::shouldSync, true);
            ((PehkuiEntityExtensions)entity).pehkui_setShouldSyncScales(false);
        }
    }

    public static void syncScalesOnTrackingStart(Entity entity, Consumer<Packet<?>> packetSender) {
        ScaleUtils.syncScales(entity, packetSender, ScaleUtils::hasScaleDataChanged, false);
    }

    private static boolean hasScaleDataChanged(ScaleData scaleData) {
        return !scaleData.hasDefaultValues();
    }

    public static void syncScales(Entity entity, Consumer<Packet<?>> packetSender, Predicate<ScaleData> condition, boolean unmark) {
        Collection<ScaleData> syncedScales = SYNCED_SCALE_DATA.get();
        for (Map.Entry<ScaleType, ScaleData> entry : ((PehkuiEntityExtensions)entity).pehkui_getScales().entrySet()) {
            ScaleData scaleData = entry.getValue();
            if (!condition.test(scaleData)) continue;
            syncedScales.add(scaleData);
            if (!unmark) continue;
            scaleData.markForSync(false);
        }
        if (!syncedScales.isEmpty()) {
            packetSender.accept(PehkuiPacketHandler.INSTANCE.toVanillaPacket((Object)new ScalePacket(entity, syncedScales), NetworkDirection.PLAY_TO_CLIENT));
            syncedScales.clear();
        }
    }

    public static double getBlockXOffset(BlockPos pos, Player player) {
        int blockCoord = pos.m_123341_();
        Direction gravity = GravityChangerCompatibility.INSTANCE.getGravityDirection(player);
        double offset = player.m_20192_() * (float)(-gravity.m_122429_());
        double footCoord = player.m_20182_().m_7096_();
        double headCoord = footCoord + offset;
        int headCoordFloored = Mth.m_14107_((double)headCoord);
        if (headCoordFloored == blockCoord) {
            return footCoord - (double)headCoordFloored;
        }
        if (headCoordFloored > blockCoord) {
            return 1.0 - offset;
        }
        return -offset;
    }

    public static double getBlockYOffset(BlockPos pos, Player player) {
        int blockCoord = pos.m_123342_();
        Direction gravity = GravityChangerCompatibility.INSTANCE.getGravityDirection(player);
        double offset = player.m_20192_() * (float)(-gravity.m_122430_());
        double footCoord = player.m_20182_().m_7098_();
        double headCoord = footCoord + offset;
        int headCoordFloored = Mth.m_14107_((double)headCoord);
        if (headCoordFloored == blockCoord) {
            return footCoord - (double)headCoordFloored;
        }
        if (headCoordFloored > blockCoord) {
            return 1.0 - offset;
        }
        return -offset;
    }

    public static double getBlockZOffset(BlockPos pos, Player player) {
        int blockCoord = pos.m_123343_();
        Direction gravity = GravityChangerCompatibility.INSTANCE.getGravityDirection(player);
        double offset = player.m_20192_() * (float)(-gravity.m_122431_());
        double footCoord = player.m_20182_().m_7094_();
        double headCoord = footCoord + offset;
        int headCoordFloored = Mth.m_14107_((double)headCoord);
        if (headCoordFloored == blockCoord) {
            return footCoord - (double)headCoordFloored;
        }
        if (headCoordFloored > blockCoord) {
            return 1.0 - offset;
        }
        return -offset;
    }

    public static float getEyeHeightScale(Entity entity) {
        return ScaleUtils.getEyeHeightScale(entity, 1.0f);
    }

    public static float getEyeHeightScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.EYE_HEIGHT, tickDelta);
    }

    public static float getThirdPersonScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.THIRD_PERSON, tickDelta);
    }

    public static float getModelWidthScale(Entity entity) {
        return ScaleUtils.getModelWidthScale(entity, 1.0f);
    }

    public static float getModelWidthScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.MODEL_WIDTH, tickDelta);
    }

    public static float getModelHeightScale(Entity entity) {
        return ScaleUtils.getModelHeightScale(entity, 1.0f);
    }

    public static float getModelHeightScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.MODEL_HEIGHT, tickDelta);
    }

    public static float getBoundingBoxWidthScale(Entity entity) {
        return ScaleUtils.getBoundingBoxWidthScale(entity, 1.0f);
    }

    public static float getBoundingBoxWidthScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.HITBOX_WIDTH, tickDelta);
    }

    public static float getBoundingBoxHeightScale(Entity entity) {
        return ScaleUtils.getBoundingBoxHeightScale(entity, 1.0f);
    }

    public static float getBoundingBoxHeightScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.HITBOX_HEIGHT, tickDelta);
    }

    public static float getFallingScale(Entity entity) {
        return ScaleUtils.getFallingScale(entity, 1.0f);
    }

    public static float getFallingScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.FALLING, tickDelta);
    }

    public static float getStepHeightScale(Entity entity) {
        return ScaleUtils.getStepHeightScale(entity, 1.0f);
    }

    public static float getStepHeightScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.STEP_HEIGHT, tickDelta);
    }

    public static float getViewBobbingScale(Entity entity) {
        return ScaleUtils.getViewBobbingScale(entity, 1.0f);
    }

    public static float getViewBobbingScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.VIEW_BOBBING, tickDelta);
    }

    public static float getVisibilityScale(Entity entity) {
        return ScaleUtils.getVisibilityScale(entity, 1.0f);
    }

    public static float getVisibilityScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.VISIBILITY, tickDelta);
    }

    public static float getJumpHeightScale(Entity entity) {
        return ScaleUtils.getJumpHeightScale(entity, 1.0f);
    }

    public static float getJumpHeightScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.JUMP_HEIGHT, tickDelta);
    }

    public static float getMotionScale(Entity entity) {
        return ScaleUtils.getMotionScale(entity, 1.0f);
    }

    public static float getMotionScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.MOTION, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledMotion).get(), tickDelta);
    }

    public static float getFlightScale(Entity entity) {
        return ScaleUtils.getFlightScale(entity, 1.0f);
    }

    public static float getFlightScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.FLIGHT, tickDelta);
    }

    public static float getBlockReachScale(Entity entity) {
        return ScaleUtils.getBlockReachScale(entity, 1.0f);
    }

    public static float getBlockReachScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.BLOCK_REACH, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledReach).get(), tickDelta);
    }

    public static float getEntityReachScale(Entity entity) {
        return ScaleUtils.getEntityReachScale(entity, 1.0f);
    }

    public static float getEntityReachScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.ENTITY_REACH, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledReach).get(), tickDelta);
    }

    public static float getMiningSpeedScale(Entity entity) {
        return ScaleUtils.getMiningSpeedScale(entity, 1.0f);
    }

    public static float getMiningSpeedScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.MINING_SPEED, tickDelta);
    }

    public static float getAttackSpeedScale(Entity entity) {
        return ScaleUtils.getAttackSpeedScale(entity, 1.0f);
    }

    public static float getAttackSpeedScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.ATTACK_SPEED, tickDelta);
    }

    public static float getKnockbackScale(Entity entity) {
        return ScaleUtils.getKnockbackScale(entity, 1.0f);
    }

    public static float getKnockbackScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.KNOCKBACK, tickDelta);
    }

    public static float getAttackScale(Entity entity) {
        return ScaleUtils.getAttackScale(entity, 1.0f);
    }

    public static float getAttackScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.ATTACK, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledAttack).get(), tickDelta);
    }

    public static float getDefenseScale(Entity entity) {
        return ScaleUtils.getDefenseScale(entity, 1.0f);
    }

    public static float getDefenseScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.DEFENSE, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledDefense).get(), tickDelta);
    }

    public static float getHealthScale(Entity entity) {
        return ScaleUtils.getHealthScale(entity, 1.0f);
    }

    public static float getHealthScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.HEALTH, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledHealth).get(), tickDelta);
    }

    public static float getDropScale(Entity entity) {
        return ScaleUtils.getDropScale(entity, 1.0f);
    }

    public static float getDropScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.DROPS, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledItemDrops).get(), tickDelta);
    }

    public static float getHeldItemScale(Entity entity) {
        return ScaleUtils.getHeldItemScale(entity, 1.0f);
    }

    public static float getHeldItemScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.HELD_ITEM, Boolean.TRUE::booleanValue, tickDelta);
    }

    public static float getProjectileScale(Entity entity) {
        return ScaleUtils.getProjectileScale(entity, 1.0f);
    }

    public static float getProjectileScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.PROJECTILES, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledProjectiles).get(), tickDelta);
    }

    public static float getExplosionScale(Entity entity) {
        return ScaleUtils.getExplosionScale(entity, 1.0f);
    }

    public static float getExplosionScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.EXPLOSIONS, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledExplosions).get(), tickDelta);
    }

    public static float getConfigurableTypedScale(Entity entity, ScaleType type, Supplier<Boolean> config, float tickDelta) {
        return config.get() != false ? ScaleUtils.getTypedScale(entity, type, tickDelta) : type.getDefaultBaseScale();
    }

    public static float getTypedScale(Entity entity, ScaleType type, float tickDelta) {
        return entity == null ? type.getDefaultBaseScale() : type.getScaleData(entity).getScale(tickDelta);
    }
}

