/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class PoisonPotatoUsageModule
extends QuarkModule {
    private static final String TAG_POISONED = "quark:poison_potato_applied";
    @Config
    public static double chance = 0.1;
    @Config
    public static boolean poisonEffect = true;

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof AgeableMob) {
            AgeableMob ageable = (AgeableMob)entity;
            if (event.getItemStack().m_41720_() == Items.f_42675_ && ageable.m_6162_() && !this.isEntityPoisoned((Entity)ageable)) {
                if (!event.getWorld().f_46443_) {
                    Vec3 pos = ageable.m_20182_();
                    if (ageable.f_19853_.f_46441_.nextDouble() < chance) {
                        ageable.m_5496_(SoundEvents.f_11912_, 0.5f, 0.25f);
                        ageable.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.2, 0.8, 0.0);
                        this.poisonEntity((Entity)ageable);
                        if (poisonEffect) {
                            ageable.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200));
                        }
                    } else {
                        ageable.m_5496_(SoundEvents.f_11912_, 0.5f, 0.5f + ageable.f_19853_.f_46441_.nextFloat() / 2.0f);
                        ageable.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.1, 0.0);
                    }
                    if (!event.getPlayer().m_150110_().f_35937_) {
                        event.getItemStack().m_41774_(1);
                    }
                } else {
                    event.getPlayer().m_6674_(event.getHand());
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        Animal animal;
        Entity entity = event.getEntity();
        if (entity instanceof Animal && (animal = (Animal)entity).m_6162_() && this.isEntityPoisoned((Entity)animal)) {
            animal.m_146762_(-24000);
        }
    }

    private boolean isEntityPoisoned(Entity e) {
        return e.getPersistentData().m_128471_(TAG_POISONED);
    }

    private void poisonEntity(Entity e) {
        e.getPersistentData().m_128379_(TAG_POISONED, true);
    }
}

