/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSlice;
import com.teamabnormals.blueprint.core.util.BiomeUtil;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ModdedBiomeSliceProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final List<Pair<ConditionedResourceSelector, ModdedBiomeSlice>> slices = new LinkedList<Pair<ConditionedResourceSelector, ModdedBiomeSlice>>();
    private final DataGenerator dataGenerator;
    private final String modid;
    private final Supplier<DynamicOps<JsonElement>> ops;

    protected ModdedBiomeSliceProvider(DataGenerator dataGenerator, String modid, DynamicOps<JsonElement> ops) {
        this.dataGenerator = dataGenerator;
        this.modid = modid;
        this.ops = () -> ops;
    }

    protected ModdedBiomeSliceProvider(DataGenerator dataGenerator, String modid) {
        this.dataGenerator = dataGenerator;
        this.modid = modid;
        this.ops = () -> RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)((RegistryAccess)RegistryAccess.f_123049_.get()));
    }

    public void m_6865_(HashCache hashCache) {
        HashSet names = new HashSet();
        Path outputFolder = this.dataGenerator.m_123916_();
        String basePath = "data/" + this.modid + "/modded_biome_slices/";
        DynamicOps<JsonElement> ops = this.ops.get();
        List<Pair<ConditionedResourceSelector, ModdedBiomeSlice>> slices = this.slices;
        slices.clear();
        this.registerSlices();
        slices.forEach(pair -> {
            ModdedBiomeSlice slice = (ModdedBiomeSlice)pair.getSecond();
            ResourceLocation name = slice.name();
            if (!names.add(name)) {
                throw new IllegalStateException("Duplicate modded biome slice: " + name);
            }
            Path path = outputFolder.resolve(basePath + name.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)hashCache, (JsonElement)slice.serializeWithSelector((ConditionedResourceSelector)pair.getFirst(), ops), (Path)path);
            }
            catch (JsonParseException | IOException exception) {
                LOGGER.error("Couldn't save modded biome slice {}", (Object)path, (Object)exception);
            }
        });
    }

    protected abstract void registerSlices();

    protected void registerSlice(String name, ConditionedResourceSelector selector, int weight, BiomeUtil.ModdedBiomeProvider provider) {
        this.slices.add((Pair<ConditionedResourceSelector, ModdedBiomeSlice>)Pair.of((Object)selector, (Object)new ModdedBiomeSlice(new ResourceLocation(this.modid, name), weight, provider)));
    }

    protected final void registerSlice(String name, int weight, BiomeUtil.ModdedBiomeProvider provider, ResourceLocation ... levels) {
        this.registerSlice(name, new ConditionedResourceSelector(new NamesResourceSelector(levels)), weight, provider);
    }

    public String m_6055_() {
        return "Modded Biome Slices: " + this.modid;
    }
}

