/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.google.common.collect.Maps;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.BiomeSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.BlockEntitySubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.EntitySubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.SoundSubRegistryHelper;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    private final Map<IForgeRegistry<?>, ISubRegistryHelper<?>> subHelpers = Maps.newHashMap();
    protected final String modId;

    public RegistryHelper(String modId) {
        this.modId = modId;
        this.putDefaultSubHelpers();
    }

    public static RegistryHelper create(String modId, Consumer<RegistryHelper> consumer) {
        RegistryHelper helper = new RegistryHelper(modId);
        consumer.accept(helper);
        return helper;
    }

    public String getModId() {
        return this.modId;
    }

    public ResourceLocation prefix(String name) {
        return new ResourceLocation(this.modId, name);
    }

    public <K extends IForgeRegistryEntry<K>> void putSubHelper(IForgeRegistry<K> registry, ISubRegistryHelper<K> subHelper) {
        this.subHelpers.put(registry, subHelper);
    }

    protected void putDefaultSubHelpers() {
        this.putSubHelper(ForgeRegistries.ITEMS, new ItemSubRegistryHelper(this));
        this.putSubHelper(ForgeRegistries.BLOCKS, new BlockSubRegistryHelper(this));
        this.putSubHelper(ForgeRegistries.SOUND_EVENTS, new SoundSubRegistryHelper(this));
        this.putSubHelper(ForgeRegistries.BLOCK_ENTITIES, new BlockEntitySubRegistryHelper(this));
        this.putSubHelper(ForgeRegistries.ENTITIES, new EntitySubRegistryHelper(this));
        this.putSubHelper(ForgeRegistries.BIOMES, new BiomeSubRegistryHelper(this));
    }

    @Nonnull
    public <T extends IForgeRegistryEntry<T>, S extends ISubRegistryHelper<T>> S getSubHelper(IForgeRegistry<T> registry) {
        ISubRegistryHelper<?> subHelper = this.subHelpers.get(registry);
        if (subHelper == null) {
            throw new NullPointerException("No Sub Helper is registered for the forge registry of type " + registry.getRegistrySuperType());
        }
        return (S)subHelper;
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<Item>> T getItemSubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(ForgeRegistries.ITEMS));
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<Block>> T getBlockSubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(ForgeRegistries.BLOCKS));
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<SoundEvent>> T getSoundSubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(ForgeRegistries.SOUND_EVENTS));
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<BlockEntityType<?>>> T getBlockEntitySubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(ForgeRegistries.BLOCK_ENTITIES));
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<EntityType<?>>> T getEntitySubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(ForgeRegistries.ENTITIES));
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<Biome>> T getBiomeSubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(ForgeRegistries.BIOMES));
    }

    public void register(IEventBus eventBus) {
        this.subHelpers.values().forEach(helper -> helper.register(eventBus));
    }
}

